/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.user;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.service.display.user.UserDisplayService;
import org.squashtest.tm.service.internal.display.dto.UserAdminViewDto;
import org.squashtest.tm.service.internal.display.dto.UserAdminViewTeamDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.project.ProjectsPermissionManagementService;
import org.squashtest.tm.service.user.ApiTokenService;
import org.squashtest.tm.service.user.UserAdministrationService;
import org.squashtest.tm.web.backend.controller.project.ProjectModel;

@RestController
@RequestMapping(value={"/backend/user-view"})
public class UserViewController {
    private final UserDisplayService userDisplayService;
    private final ProjectsPermissionManagementService permissionService;
    private final UserAdministrationService userAdministrationService;
    private final ApiTokenService apiTokenService;

    @Inject
    UserViewController(UserDisplayService userDisplayService, ProjectsPermissionManagementService permissionService, UserAdministrationService userAdministrationService, ApiTokenService apiTokenService) {
        this.userDisplayService = userDisplayService;
        this.permissionService = permissionService;
        this.userAdministrationService = userAdministrationService;
        this.apiTokenService = apiTokenService;
    }

    @RequestMapping(value={"/{userId}"}, method={RequestMethod.GET})
    public UserAdminViewDto getUserView(@PathVariable long userId) {
        return this.userDisplayService.getUserView(userId);
    }

    @GetMapping(value={"/{userId}/projects-without-permission"})
    public List<ProjectModel> getProjectWithoutPermission(@PathVariable long userId) {
        List projectList = this.permissionService.findProjectWithoutPermissionByParty(userId, Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"name"}));
        ArrayList<ProjectModel> projectModelList = new ArrayList<ProjectModel>();
        if (projectList != null) {
            for (GenericProject project : projectList) {
                projectModelList.add(new ProjectModel(project));
            }
        }
        return projectModelList;
    }

    @GetMapping(value={"/{userId}/unassociated-teams"})
    public List<UserAdminViewTeamDto> getUnassociatedTeams(@PathVariable long userId) {
        List teams = this.userAdministrationService.findAllNonAssociatedTeams(userId);
        ArrayList<UserAdminViewTeamDto> unassociatedTeamsList = new ArrayList<UserAdminViewTeamDto>();
        if (teams != null) {
            teams.forEach(team -> {
                UserAdminViewTeamDto unassociatedTeam = new UserAdminViewTeamDto();
                unassociatedTeam.setPartyId(team.getId());
                unassociatedTeam.setName(team.getName());
                unassociatedTeamsList.add(unassociatedTeam);
            });
        }
        return unassociatedTeamsList;
    }

    @PostMapping(value={"{userId}/api-tokens"})
    public GridResponse findTestAutoServerApiTokens(@PathVariable long userId, @RequestBody GridRequest request) {
        return this.userDisplayService.findTestAutoServerApiTokens(userId, request);
    }

    @DeleteMapping(value={"delete-token/{tokenId}"})
    public void deleteTestAutoServerApiToken(@PathVariable long tokenId) {
        this.apiTokenService.deleteTestAutoServerApiToken(tokenId);
    }
}

