/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.user;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsDetailedException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.domain.users.UsersGroup;
import org.squashtest.tm.exception.bugtracker.BadCredentialsException;
import org.squashtest.tm.exception.bugtracker.CannotConnectBugtrackerException;
import org.squashtest.tm.service.internal.display.dto.BugTrackerCredentialsDto;
import org.squashtest.tm.service.internal.display.dto.BugTrackerDto;
import org.squashtest.tm.service.internal.display.dto.CredentialsDto;
import org.squashtest.tm.service.internal.display.dto.ProjectPermissionDto;
import org.squashtest.tm.service.internal.display.dto.UserAccountDto;
import org.squashtest.tm.service.internal.display.dto.UsersGroupDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.security.AuthenticationProviderContext;
import org.squashtest.tm.service.internal.servers.OAuth2ConsumerService;
import org.squashtest.tm.service.project.ProjectsPermissionFinder;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.user.PartyPreferenceService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.web.backend.controller.user.PasswordChangeForm;
import org.squashtest.tm.web.backend.controller.user.UserAccountController;

@RestController
@RequestMapping(value={"backend/user-account"})
public class UserAccountController {
    private static final String SQUASH_BUGTRACKER_MODE = "squash.bug.tracker.mode";
    private final UserAccountService userAccountService;
    private final ProjectsPermissionFinder permissionFinder;
    private final PartyPreferenceService partyPreferenceService;
    private final StoredCredentialsManager credentialsManager;
    private final AuthenticationProviderContext authenticationProviderContext;
    private final OAuth2ConsumerService oAuth2ConsumerService;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$squashtest$tm$domain$servers$AuthenticationProtocol;

    UserAccountController(UserAccountService userAccountService, ProjectsPermissionFinder permissionFinder, PartyPreferenceService partyPreferenceService, StoredCredentialsManager credentialsManager, AuthenticationProviderContext authenticationProviderContext, OAuth2ConsumerService oAuth2ConsumerService) {
        this.userAccountService = userAccountService;
        this.permissionFinder = permissionFinder;
        this.partyPreferenceService = partyPreferenceService;
        this.credentialsManager = credentialsManager;
        this.authenticationProviderContext = authenticationProviderContext;
        this.oAuth2ConsumerService = oAuth2ConsumerService;
    }

    @GetMapping
    public UserAccountDto getUserAccountDetails() {
        UserAccountDto dto = new UserAccountDto();
        User user = this.userAccountService.findCurrentUser();
        dto.setId(user.getId());
        dto.setFirstName(user.getFirstName());
        dto.setLastName(user.getLastName());
        dto.setLogin(user.getLogin());
        dto.setUserGroup(UsersGroupDto.from((UsersGroup)user.getGroup()));
        dto.setEmail(user.getEmail());
        List projectPermissions = this.permissionFinder.findProjectPermissionByUserLogin(user.getLogin()).stream().map(ProjectPermissionDto::from).collect(Collectors.toList());
        dto.setProjectPermissions(projectPermissions);
        Party party = this.userAccountService.getParty(user.getId());
        Map map = this.partyPreferenceService.findPreferences(party);
        dto.setBugTrackerMode((String)map.get(SQUASH_BUGTRACKER_MODE));
        dto.setBugTrackerCredentials(this.getBugtrackerCredentials());
        dto.setCanManageLocalPassword(this.authenticationProviderContext.isInternalProviderEnabled());
        dto.setHasLocalPassword(this.userAccountService.hasCurrentUserPasswordDefined());
        return dto;
    }

    @PostMapping(value={"{partyId}/email"})
    void changeEmail(@PathVariable Long partyId, @RequestBody UserAccountChangeRequest requestBody) {
        this.userAccountService.setCurrentUserEmail(requestBody.getEmail());
    }

    @PostMapping(value={"/password"})
    public void changePassword(@Valid @RequestBody PasswordChangeForm form) {
        if (form.isInitializing()) {
            this.userAccountService.setCurrentUserPassword(form.getNewPassword());
        } else {
            this.userAccountService.setCurrentUserPassword(form.getOldPassword(), form.getNewPassword());
        }
    }

    @RequestMapping(value={"/bug-tracker-mode"}, method={RequestMethod.POST})
    public void changeUserBugtrackerMode(@RequestBody UserAccountChangeRequest requestBody) {
        this.partyPreferenceService.addOrUpdatePreferenceForCurrentUser(SQUASH_BUGTRACKER_MODE, requestBody.getBugTrackerMode());
    }

    private List<BugTrackerCredentialsDto> getBugtrackerCredentials() {
        return this.userAccountService.findAllUserBugTracker().stream().sorted(Comparator.comparing(ThirdPartyServer::getAuthenticationProtocol)).map(bt -> {
            BugTrackerCredentialsDto dto = new BugTrackerCredentialsDto();
            BugTrackerDto bugTrackerDto = BugTrackerDto.from((BugTracker)bt);
            dto.setBugTracker(bugTrackerDto);
            dto.setCredentials(CredentialsDto.from((ManageableCredentials)this.getOrCreateCredentials(bt)));
            return dto;
        }).collect(Collectors.toList());
    }

    /*
     * Exception decompiling
     */
    private ManageableCredentials getOrCreateCredentials(BugTracker bugtracker) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @PostMapping(value={"bugtracker/{bugTrackerId}/credentials"})
    public void saveCurrentUserCredentials(@PathVariable long bugTrackerId, @RequestBody ManageableCredentials credentials) {
        try {
            this.userAccountService.testCurrentUserCredentials(bugTrackerId, credentials);
            this.userAccountService.saveCurrentUserCredentials(bugTrackerId, credentials);
        }
        catch (BugTrackerNoCredentialsDetailedException | BugTrackerNoCredentialsException e) {
            throw new BadCredentialsException((Exception)e);
        }
        catch (BugTrackerRemoteException ex) {
            throw new CannotConnectBugtrackerException((Exception)((Object)ex));
        }
    }

    @PostMapping(value={"bugtracker/{bugTrackerId}/authentication/oauth2/token"})
    public void askOauth2Token(@PathVariable(value="bugTrackerId") long bugTrackerId, @RequestParam(value="code") String code) {
        this.oAuth2ConsumerService.getCurrentUserOauth2token(bugTrackerId, code);
    }

    @DeleteMapping(value={"bugtracker/{bugTrackerId}/credentials"})
    public void deleteUserCredentials(@PathVariable long bugTrackerId) {
        this.userAccountService.deleteCurrentUserCredentials(bugTrackerId);
    }

    @PostMapping(value={"personal-api-tokens"})
    public GridResponse findPersonalApiTokens(@RequestBody GridRequest request) {
        return this.userAccountService.findPersonalApiTokens(request);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$squashtest$tm$domain$servers$AuthenticationProtocol() {
        if ($SWITCH_TABLE$org$squashtest$tm$domain$servers$AuthenticationProtocol != null) {
            return $SWITCH_TABLE$org$squashtest$tm$domain$servers$AuthenticationProtocol;
        }
        int[] nArray = new int[AuthenticationProtocol.values().length];
        try {
            nArray[AuthenticationProtocol.BASIC_AUTH.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AuthenticationProtocol.OAUTH_1A.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AuthenticationProtocol.OAUTH_2.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AuthenticationProtocol.TOKEN_AUTH.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$squashtest$tm$domain$servers$AuthenticationProtocol = nArray;
        return nArray;
    }
}

