/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.user;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.user.ApiTokenService;
import org.squashtest.tm.web.backend.controller.user.ApiTokenController;

@RestController
@RequestMapping(value={"backend/api-token"})
public class ApiTokenController {
    private final ApiTokenService apiTokenService;

    public ApiTokenController(ApiTokenService apiTokenService) {
        this.apiTokenService = apiTokenService;
    }

    @PostMapping(value={"generate-api-token"})
    public Map<String, String> generateApiToken(@RequestBody ApiTokenModel apiTokenModel) {
        String userToken = this.apiTokenService.generateApiToken(apiTokenModel.name, apiTokenModel.expiryDate, apiTokenModel.permissions).generatedJwtToken();
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("token", Base64.getEncoder().encodeToString(userToken.getBytes()));
        return response;
    }

    @PostMapping(value={"generate-api-token/{userId}"})
    public Map<String, String> generateApiTokenForTestAutoServerUser(@PathVariable long userId, @RequestBody ApiTokenModel apiTokenModel) {
        String userToken = this.apiTokenService.generateApiTokenForTestAutoServer(userId, apiTokenModel.name, apiTokenModel.expiryDate, apiTokenModel.permissions).generatedJwtToken();
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("token", Base64.getEncoder().encodeToString(userToken.getBytes()));
        return response;
    }

    @DeleteMapping(value={"{tokenId}"})
    public void deleteSelfApiToken(@PathVariable long tokenId) {
        this.apiTokenService.deletePersonalApiToken(tokenId);
    }
}

