/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.tf;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.display.tf.AutomationRequestDisplayService;
import org.squashtest.tm.service.display.tf.AutomationWorkspaceDataProviderService;
import org.squashtest.tm.service.internal.display.dto.tf.AutomationWorkspaceDataDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;

@RestController
@RequestMapping(value={"backend/automation-workspace"})
public class AutomationWorkspaceController {
    private final AutomationRequestDisplayService automationRequestDisplayService;
    private final AutomationWorkspaceDataProviderService automationWorkspaceDataProviderService;

    public AutomationWorkspaceController(AutomationRequestDisplayService automationRequestDisplayService, AutomationWorkspaceDataProviderService automationWorkspaceDataProviderService) {
        this.automationRequestDisplayService = automationRequestDisplayService;
        this.automationWorkspaceDataProviderService = automationWorkspaceDataProviderService;
    }

    @GetMapping(value={"data"})
    public AutomationWorkspaceDataDto getWorkspaceRefData() {
        return this.automationWorkspaceDataProviderService.findData();
    }

    @PostMapping(value={"assignee-autom-req"})
    public GridResponse getAutomationRequestForAssignView(@RequestBody GridRequest request) {
        return this.automationRequestDisplayService.findAutomationRequestAssignedToCurrentUser(request);
    }

    @PostMapping(value={"treatment-autom-req"})
    public GridResponse getAutomationRequestForTreatmentView(@RequestBody GridRequest request) {
        return this.automationRequestDisplayService.findAutomationRequestToTreat(request);
    }

    @PostMapping(value={"global-autom-req"})
    public GridResponse getAutomationRequestForGlobalView(@RequestBody GridRequest request) {
        return this.automationRequestDisplayService.findAutomationRequests(request);
    }
}

