/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.tf;

import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.service.internal.dto.executioncomparator.TestExecutionInfo;
import org.squashtest.tm.service.internal.testautomation.testplanretriever.RestTestPlanFinderImpl;
import org.squashtest.tm.service.testautomation.AutomatedSuiteManagerService;
import org.squashtest.tm.service.testautomation.AutomatedSuitePreviewService;
import org.squashtest.tm.service.testautomation.TestExecutionInfoService;
import org.squashtest.tm.service.testautomation.model.AutomatedSuiteCreationSpecification;
import org.squashtest.tm.service.testautomation.model.AutomatedSuitePreview;
import org.squashtest.tm.service.testautomation.supervision.AutomatedExecutionViewUtils;
import org.squashtest.tm.service.testautomation.supervision.model.AutomatedSuiteOverview;

@RestController
@RequestMapping(value={"backend/automated-suites"})
public class AutomatedSuiteManagementController {
    private final AutomatedSuiteManagerService automatedSuiteService;
    private final TestExecutionInfoService testExecutionInfoService;
    private final AutomatedSuitePreviewService automatedSuitePreviewService;
    private final RestTestPlanFinderImpl testPlanFinder;

    public AutomatedSuiteManagementController(AutomatedSuiteManagerService automatedSuiteService, TestExecutionInfoService testExecutionInfoService, AutomatedSuitePreviewService automatedSuitePreviewService, RestTestPlanFinderImpl testPlanFinder) {
        this.automatedSuiteService = automatedSuiteService;
        this.testExecutionInfoService = testExecutionInfoService;
        this.automatedSuitePreviewService = automatedSuitePreviewService;
        this.testPlanFinder = testPlanFinder;
    }

    @PostMapping(value={"/preview"})
    public AutomatedSuitePreview generateSuitePreview(@RequestBody AutomatedSuiteCreationSpecification specification) {
        return this.automatedSuitePreviewService.preview(specification);
    }

    @PostMapping(value={"/preview/test-list"}, params={"auto-project-id"})
    public List<String> findTestListPreview(@RequestBody AutomatedSuiteCreationSpecification specification, @RequestParam(value="auto-project-id") Long automatedProjectId) {
        return this.automatedSuitePreviewService.findTestListPreview(specification, automatedProjectId.longValue());
    }

    @PostMapping(value={"/create-and-execute"})
    public AutomatedSuiteOverview createAndExecute(@RequestBody AutomatedSuiteCreationSpecification specification) {
        List itemTestPlanIds = this.testPlanFinder.getItemTestPlanIdsFromSpecification(specification);
        return this.automatedSuiteService.createAndExecute(specification, itemTestPlanIds);
    }

    @GetMapping(value={"/{suiteId}/executions"})
    public AutomatedSuiteOverview updateExecutionInfo(@PathVariable String suiteId) {
        AutomatedSuite suite = this.automatedSuiteService.findById(suiteId);
        return AutomatedExecutionViewUtils.buildAutomatedSuiteOverview((AutomatedSuite)suite);
    }

    @PostMapping(value={"/compare-executions"})
    public List<TestExecutionInfo> compareExecutions(@RequestBody List<String> suiteIds) {
        return this.testExecutionInfoService.compareExecutionsBySuites(suiteIds);
    }

    @PostMapping(value={"/deletion"})
    public void deleteAutomatedSuites(@RequestBody List<String> suiteIds) {
        this.automatedSuiteService.deleteAutomatedSuites(suiteIds);
    }

    @PostMapping(value={"/attachment-prune"}, params={"complete"})
    public void pruneAutomatedSuites(@RequestBody List<String> suiteIds, @RequestParam(value="complete") boolean complete) {
        this.automatedSuiteService.pruneAutomatedSuites(suiteIds, complete);
    }
}

