/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testcase.parameters;

import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.service.display.testcase.TestCaseDisplayService;
import org.squashtest.tm.service.internal.display.testcase.parameter.TestCaseParameterOperationReport;
import org.squashtest.tm.service.testcase.ParameterModificationService;
import org.squashtest.tm.web.backend.controller.testcase.parameters.ParameterPatch;

@RestController
@RequestMapping(value={"backend/test-cases/{testCaseId}/parameters"})
public class TestCaseParametersController {
    private final ParameterModificationService parameterService;
    private final TestCaseDisplayService testCaseDisplayService;

    public TestCaseParametersController(ParameterModificationService parameterService, TestCaseDisplayService testCaseDisplayService) {
        this.parameterService = parameterService;
        this.testCaseDisplayService = testCaseDisplayService;
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.POST})
    public TestCaseParameterOperationReport newParameter(@RequestBody ParameterPatch parameterPatch, @PathVariable Long testCaseId) {
        Parameter param = new Parameter();
        param.setName(parameterPatch.getName());
        param.setDescription(parameterPatch.getDescription());
        this.parameterService.addNewParameterToTestCase(param, testCaseId.longValue());
        return this.testCaseDisplayService.findParametersData(testCaseId);
    }
}

