/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testcase.parameters;

import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.service.internal.display.testcase.parameter.NewDatasetData;
import org.squashtest.tm.service.testcase.DatasetModificationService;

@RestController
@RequestMapping(value={"backend/datasets"})
public class DatasetModificationController {
    private final DatasetModificationService datasetModificationService;

    public DatasetModificationController(DatasetModificationService datasetModificationService) {
        this.datasetModificationService = datasetModificationService;
    }

    @RequestMapping(value={"/{dataSetId}"}, method={RequestMethod.DELETE})
    public void deleteDataSet(@PathVariable Long dataSetId) {
        this.datasetModificationService.removeById(dataSetId.longValue());
    }

    @RequestMapping(value={"/rename"}, method={RequestMethod.POST})
    public void rename(@RequestBody NewDatasetData dataset) {
        try {
            this.datasetModificationService.changeName(dataset.getId().longValue(), dataset.getName());
        }
        catch (DuplicateNameException ex) {
            throw new NameAlreadyInUseException("Dataset", dataset.getName(), (Exception)((Object)ex));
        }
    }
}

