/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testcase;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.service.display.testcase.TestCaseDisplayService;
import org.squashtest.tm.service.internal.display.dto.AutomationRequestDto;
import org.squashtest.tm.service.internal.display.testcase.parameter.TestCaseParameterOperationReport;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.service.tf.AutomationRequestModificationService;
import org.squashtest.tm.web.backend.controller.testcase.TestCaseViewModificationController;

@RestController
@RequestMapping(value={"backend/test-case/{testCaseId}"})
public class TestCaseViewModificationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCaseViewModificationController.class);
    private static final String TEST_SPACE_CASE = "test case ";
    private final TestCaseModificationService testCaseModificationService;
    private final AutomationRequestModificationService automationRequestModificationService;
    private final TestCaseDisplayService testCaseDisplayService;

    public TestCaseViewModificationController(TestCaseModificationService testCaseModificationService, AutomationRequestModificationService automationRequestModificationService, TestCaseDisplayService testCaseDisplayService) {
        this.testCaseModificationService = testCaseModificationService;
        this.automationRequestModificationService = automationRequestModificationService;
        this.testCaseDisplayService = testCaseDisplayService;
    }

    @RequestMapping(value={"/importance"}, method={RequestMethod.POST})
    public void changeImportance(@PathVariable long testCaseId, @RequestBody TestCasePatch patch) {
        this.testCaseModificationService.changeImportance(testCaseId, TestCaseImportance.valueOf((String)patch.getImportance()));
    }

    @RequestMapping(value={"/name"}, method={RequestMethod.POST})
    public void changeName(@PathVariable long testCaseId, @RequestBody TestCasePatch patch) {
        this.testCaseModificationService.rename(testCaseId, patch.getName());
    }

    @RequestMapping(value={"/reference"}, method={RequestMethod.POST})
    public void changeReference(@PathVariable long testCaseId, @RequestBody TestCasePatch patch) {
        this.testCaseModificationService.changeReference(testCaseId, patch.getReference());
    }

    @RequestMapping(value={"/status"}, method={RequestMethod.POST})
    public void changeStatus(@PathVariable long testCaseId, @RequestBody TestCasePatch patch) {
        this.testCaseModificationService.changeStatus(testCaseId, TestCaseStatus.valueOf((String)patch.getStatus()));
    }

    @RequestMapping(value={"/importance-auto"}, method={RequestMethod.POST})
    public Map<String, String> changeImportanceAuto(@PathVariable long testCaseId, @RequestBody TestCasePatch patch) {
        this.testCaseModificationService.changeImportanceAuto(testCaseId, patch.isImportanceAuto());
        TestCase testCase = this.testCaseModificationService.findById(testCaseId);
        HashMap<String, String> testCaseImportance = new HashMap<String, String>();
        testCaseImportance.put("importance", testCase.getImportance().name());
        return testCaseImportance;
    }

    @RequestMapping(value={"/nature"}, method={RequestMethod.POST})
    public void changeNature(@PathVariable long testCaseId, @RequestBody TestCasePatch patch) {
        this.testCaseModificationService.changeNature(testCaseId, patch.getNature().longValue());
    }

    @RequestMapping(value={"/type"}, method={RequestMethod.POST})
    public void changeType(@PathVariable long testCaseId, @RequestBody TestCasePatch patch) {
        this.testCaseModificationService.changeType(testCaseId, patch.getType().longValue());
    }

    @RequestMapping(value={"/description"}, method={RequestMethod.POST})
    public void changeDescription(@RequestBody TestCasePatch patch, @PathVariable long testCaseId) {
        this.testCaseModificationService.changeDescription(testCaseId, patch.getDescription());
    }

    @RequestMapping(value={"/milestones/{milestoneIds}"}, method={RequestMethod.POST})
    public void bindMilestones(@PathVariable long testCaseId, @PathVariable(value="milestoneIds") List<Long> milestoneIds) {
        this.testCaseModificationService.bindMilestones(testCaseId, milestoneIds);
    }

    @RequestMapping(value={"/milestones/{milestoneIds}"}, method={RequestMethod.DELETE})
    public void unbindMilestones(@PathVariable long testCaseId, @PathVariable List<Long> milestoneIds) {
        this.testCaseModificationService.unbindMilestones(testCaseId, milestoneIds);
    }

    @RequestMapping(value={"/automatable"}, method={RequestMethod.POST})
    public AutomationRequestDto changeAutomatable(@RequestBody TestCasePatch patch, @PathVariable long testCaseId) {
        return this.testCaseModificationService.changeAutomatable(TestCaseAutomatable.valueOf((String)patch.getAutomatable()), Long.valueOf(testCaseId));
    }

    @RequestMapping(value={"/prerequisite"}, method={RequestMethod.POST})
    public TestCaseParameterOperationReport changePrerequisite(@PathVariable long testCaseId, @RequestBody TestCasePatch patch) {
        this.testCaseModificationService.changePrerequisite(testCaseId, patch.getPrerequisite());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(TEST_SPACE_CASE + testCaseId + ": updated prerequisite to " + patch.getPrerequisite());
        }
        return this.testCaseDisplayService.findParametersData(Long.valueOf(testCaseId));
    }

    @RequestMapping(value={"/automation-request/priority"}, method={RequestMethod.POST})
    public void changeAutomationRequestPriority(@RequestBody Map<String, Integer> request, @PathVariable long testCaseId) {
        this.automationRequestModificationService.changePriority(Collections.singletonList(testCaseId), request.get("priority"));
    }

    @PostMapping(value={"/scm-repository-id"})
    public void changeScmRepository(@RequestBody TestCasePatch testCasePatch, @PathVariable long testCaseId) {
        if (testCasePatch.getScmRepositoryId() == null || testCasePatch.getScmRepositoryId().equals(0L)) {
            this.testCaseModificationService.unbindSourceCodeRepository(testCaseId);
        } else {
            String newScmRepositoryUrl = this.testCaseModificationService.changeSourceCodeRepository(testCaseId, testCasePatch.getScmRepositoryId().longValue());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(TEST_SPACE_CASE + testCaseId + ": updated git repository to " + newScmRepositoryUrl);
            }
        }
    }

    @PostMapping(value={"/automated-test-technology"})
    public void changeAutomatedTestTechnology(@RequestBody TestCasePatch testCasePatch, @PathVariable long testCaseId) {
        if (testCasePatch.getAutomatedTestTechnology() != null) {
            this.testCaseModificationService.changeAutomatedTestTechnology(testCaseId, testCasePatch.getAutomatedTestTechnology().longValue());
        } else {
            this.testCaseModificationService.unbindAutomatedTestTechnology(testCaseId);
        }
    }

    @PostMapping(value={"/automated-test-reference"})
    public void changeAutomatedTestReference(@RequestBody TestCasePatch testCasePatch, @PathVariable long testCaseId) {
        this.testCaseModificationService.changeAutomatedTestReference(testCaseId, testCasePatch.getAutomatedTestReference());
    }
}

