/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.test.automation.server.environments.serverlevel;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.display.test.automation.server.TestAutomationServerDisplayService;
import org.squashtest.tm.service.internal.display.dto.automatedexecutionenvironments.EnvironmentSelectionPanelDto;
import org.squashtest.tm.service.project.GenericProjectFinder;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.testautomation.TestAutomationServerManagerService;
import org.squashtest.tm.service.testautomation.environment.AutomatedExecutionEnvironmentService;
import org.squashtest.tm.service.testautomation.spi.InvalidSquashOrchestratorConfigurationException;
import org.squashtest.tm.service.testautomation.spi.OutdatedSquashOrchestratorException;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;
import org.squashtest.tm.web.backend.controller.form.model.StringList;
import org.squashtest.tm.web.backend.controller.test.automation.server.environments.AbstractTAEnvironmentsController;

@RestController
@RequestMapping(value={"/backend/test-automation-servers/"})
public class ServerLevelTAEnvironmentsController
extends AbstractTAEnvironmentsController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerLevelTAEnvironmentsController.class);
    private final TestAutomationServerManagerService testAutomationServerManagerService;

    public ServerLevelTAEnvironmentsController(AutomatedExecutionEnvironmentService automatedExecutionEnvironmentService, TestAutomationServerDisplayService testAutomationServerDisplayService, TestAutomationServerManagerService testAutomationServerManagerService, StoredCredentialsManager storedCredentialsManager, GenericProjectFinder genericProjectFinder) {
        super(automatedExecutionEnvironmentService, storedCredentialsManager, genericProjectFinder, testAutomationServerDisplayService);
        this.testAutomationServerManagerService = testAutomationServerManagerService;
    }

    @GetMapping(value={"{testAutomationServerId}/automated-execution-environments/all"})
    public EnvironmentSelectionPanelDto getServerEnvironmentsPanel(@PathVariable Long testAutomationServerId) {
        if (this.testAutomationServerDisplayService.hasDefinedCredentials(testAutomationServerId.longValue())) {
            List allAccessibleEnvironments;
            List defaultTags;
            block4: {
                defaultTags = this.testAutomationServerDisplayService.getDefaultEnvironmentTags(testAutomationServerId.longValue());
                allAccessibleEnvironments = null;
                try {
                    allAccessibleEnvironments = this.automatedExecutionEnvironmentService.getAllAccessibleEnvironments(testAutomationServerId);
                }
                catch (InvalidSquashOrchestratorConfigurationException | OutdatedSquashOrchestratorException ex) {
                    LOGGER.error(String.format("Could not fetch available automated execution environments for server %d.", testAutomationServerId), ex);
                    return EnvironmentSelectionPanelDto.forServerWithError((Long)testAutomationServerId, (List)defaultTags, (String)ex.getMessage());
                }
                catch (TestAutomationException ex) {
                    if (!LOGGER.isTraceEnabled()) break block4;
                    LOGGER.trace(String.format("Could not fetch available automated execution environments for server %d.", testAutomationServerId), (Throwable)ex);
                }
            }
            return EnvironmentSelectionPanelDto.forServer((Long)testAutomationServerId, (List)defaultTags, (List)allAccessibleEnvironments);
        }
        return EnvironmentSelectionPanelDto.forServerWithoutCredentials((Long)testAutomationServerId);
    }

    @GetMapping(value={"{testAutomationServerId}/available-tags"})
    public StringList getAvailableServerEnvironmentTags(@PathVariable Long testAutomationServerId) {
        return this.getAvailableServerEnvironmentTags(testAutomationServerId, null);
    }

    @PostMapping(value={"{testAutomationServerId}/environment-tags"})
    public void updateServerEnvironmentTags(@PathVariable Long testAutomationServerId, @RequestBody StringList tagList) {
        this.testAutomationServerManagerService.updateEnvironmentTags(testAutomationServerId.longValue(), tagList.getList());
    }
}

