/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.test.automation.server.environments;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.service.display.test.automation.server.TestAutomationServerDisplayService;
import org.squashtest.tm.service.internal.display.dto.automatedexecutionenvironments.EnvironmentSelectionPanelDto;
import org.squashtest.tm.service.project.GenericProjectFinder;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.testautomation.environment.AutomatedExecutionEnvironmentService;
import org.squashtest.tm.service.testautomation.model.AutomatedExecutionEnvironment;
import org.squashtest.tm.service.testautomation.spi.InvalidSquashOrchestratorConfigurationException;
import org.squashtest.tm.service.testautomation.spi.OutdatedSquashOrchestratorException;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;
import org.squashtest.tm.web.backend.controller.form.model.StringList;

public abstract class AbstractTAEnvironmentsController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTAEnvironmentsController.class);
    protected final AutomatedExecutionEnvironmentService automatedExecutionEnvironmentService;
    protected final TestAutomationServerDisplayService testAutomationServerDisplayService;
    private final GenericProjectFinder genericProjectFinder;
    private final StoredCredentialsManager storedCredentialsManager;

    protected AbstractTAEnvironmentsController(AutomatedExecutionEnvironmentService automatedExecutionEnvironmentService, StoredCredentialsManager storedCredentialsManager, GenericProjectFinder genericProjectFinder, TestAutomationServerDisplayService testAutomationServerDisplayService) {
        this.automatedExecutionEnvironmentService = automatedExecutionEnvironmentService;
        this.storedCredentialsManager = storedCredentialsManager;
        this.genericProjectFinder = genericProjectFinder;
        this.testAutomationServerDisplayService = testAutomationServerDisplayService;
    }

    protected StringList getAvailableProjectEnvironmentTags(long genericProjectId, Long testAutomationServerId) {
        Optional optionalProjectToken = this.findProjectToken(testAutomationServerId, genericProjectId);
        return this.getAvailableServerEnvironmentTags(testAutomationServerId, (TokenAuthCredentials)optionalProjectToken.orElse(null));
    }

    protected StringList getAvailableServerEnvironmentTags(Long testAutomationServerId, TokenAuthCredentials token) {
        List environments = this.getAutomatedExecutionEnvironments(testAutomationServerId, token);
        return new StringList(this.extractAllTags(environments));
    }

    protected List<String> extractAllTags(List<AutomatedExecutionEnvironment> environments) {
        return environments.stream().map(AutomatedExecutionEnvironment::getTags).flatMap(Collection::stream).distinct().sorted().collect(Collectors.toList());
    }

    public EnvironmentSelectionPanelDto getProjectEnvironmentsPanel(long genericProjectId, Long testAutomationServerId) {
        boolean hasServerToken = this.testAutomationServerDisplayService.hasDefinedCredentials(testAutomationServerId.longValue());
        Optional optionalProjectToken = this.findProjectToken(testAutomationServerId, genericProjectId);
        boolean hasProjectToken = optionalProjectToken.isPresent();
        if (hasServerToken || hasProjectToken) {
            return this.getProjectEnvironmentPanelResponse(Long.valueOf(genericProjectId), testAutomationServerId, (TokenAuthCredentials)optionalProjectToken.orElse(null), hasServerToken, hasProjectToken);
        }
        return EnvironmentSelectionPanelDto.forProjectWithoutCredentials((Long)testAutomationServerId, (Long)genericProjectId);
    }

    protected List<AutomatedExecutionEnvironment> getAutomatedExecutionEnvironments(Long testAutomationServerId, TokenAuthCredentials optionalProjectToken) {
        return optionalProjectToken != null ? this.automatedExecutionEnvironmentService.getAllAccessibleEnvironments(testAutomationServerId, (Credentials)optionalProjectToken) : this.automatedExecutionEnvironmentService.getAllAccessibleEnvironments(testAutomationServerId);
    }

    protected Optional<TokenAuthCredentials> findProjectToken(Long testAutomationServerId, long projectId) {
        return Optional.ofNullable(this.storedCredentialsManager.findProjectCredentials(testAutomationServerId.longValue(), projectId)).filter(TokenAuthCredentials.class::isInstance).map(TokenAuthCredentials.class::cast);
    }

    private EnvironmentSelectionPanelDto getProjectEnvironmentPanelResponse(Long genericProjectId, Long testAutomationServerId, TokenAuthCredentials optionalProjectToken, boolean hasServerCredentials, boolean hasProjectToken) {
        String errorMessage;
        List allAccessibleEnvironments;
        boolean areProjectTagsInherited;
        List projectTags;
        List defaultTags;
        block4: {
            defaultTags = this.testAutomationServerDisplayService.getDefaultEnvironmentTags(testAutomationServerId.longValue());
            projectTags = this.genericProjectFinder.getProjectEnvironmentTags(genericProjectId.longValue());
            areProjectTagsInherited = this.genericProjectFinder.isInheritsEnvironmentTags(genericProjectId.longValue());
            allAccessibleEnvironments = null;
            errorMessage = null;
            try {
                allAccessibleEnvironments = this.getAutomatedExecutionEnvironments(testAutomationServerId, optionalProjectToken);
            }
            catch (InvalidSquashOrchestratorConfigurationException | OutdatedSquashOrchestratorException ex) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(String.format("Could not fetch available automated execution environments for project %d.", genericProjectId), ex);
                }
                errorMessage = ex.getMessage();
            }
            catch (TestAutomationException ex) {
                if (!LOGGER.isTraceEnabled()) break block4;
                LOGGER.trace(String.format("Could not fetch available automated execution environments for project %d.", genericProjectId), (Throwable)ex);
            }
        }
        return EnvironmentSelectionPanelDto.forProject((Long)testAutomationServerId, (List)defaultTags, (boolean)hasServerCredentials, (List)allAccessibleEnvironments, (Long)genericProjectId, (boolean)hasProjectToken, (List)projectTags, (boolean)areProjectTagsInherited, (String)errorMessage);
    }
}

