/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.system;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.api.report.DocxTemplaterReport;
import org.squashtest.tm.api.wizard.SynchronisationPlugin;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.service.actionword.ActionWordLibraryNodeService;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.display.dto.RemoteSynchronisationDto;
import org.squashtest.tm.service.internal.display.dto.ReportTemplateModel;
import org.squashtest.tm.service.internal.display.dto.SynchronisationPluginViewDto;
import org.squashtest.tm.service.internal.display.dto.SystemViewDto;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.project.CustomProjectFinder;
import org.squashtest.tm.service.system.LogFileDownloadService;
import org.squashtest.tm.service.system.SystemAdministrationService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.service.user.UserManagerService;
import org.squashtest.tm.web.backend.report.IdentifiedReportDecorator;
import org.squashtest.tm.web.backend.report.ReportsRegistry;

@RestController
@RequestMapping(value={"/backend/system-view"})
public class SystemViewController {
    private final SystemAdministrationService systemAdministrationService;
    private final FeatureManager featureManager;
    private final UserManagerService userManagerService;
    private final ActionWordLibraryNodeService actionWordLibraryNodeService;
    private final ReportsRegistry reportsRegistry;
    private final UserAccountService userAccountService;
    private final CustomProjectFinder customProjectFinder;
    private final LogFileDownloadService logFileDownloadService;
    @Value(value="${info.app.version}")
    private String appVersion;
    @Value(value="${squashtm.stack.trace.control.panel.visible:false}")
    private Boolean stackTracePanelIsVisible;
    @Autowired(required=false)
    private Collection<SynchronisationPlugin> synchronisationPlugins = Collections.emptyList();

    SystemViewController(SystemAdministrationService administrationService, FeatureManager featureManager, UserManagerService userManagerService, ActionWordLibraryNodeService actionWordLibraryNodeService, ReportsRegistry reportsRegistry, UserAccountService userAccountService, CustomProjectFinder customProjectFinder, LogFileDownloadService logFileDownloadService) {
        this.systemAdministrationService = administrationService;
        this.featureManager = featureManager;
        this.userManagerService = userManagerService;
        this.actionWordLibraryNodeService = actionWordLibraryNodeService;
        this.reportsRegistry = reportsRegistry;
        this.userAccountService = userAccountService;
        this.customProjectFinder = customProjectFinder;
        this.logFileDownloadService = logFileDownloadService;
    }

    @GetMapping
    public SystemViewDto getSystemView() {
        SystemViewDto dto = new SystemViewDto();
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        if (currentUser.isAdmin()) {
            dto.setStatistics(this.systemAdministrationService.findAdministrationStatistics());
            dto.setAppVersion(this.appVersion);
            dto.setPlugins(this.systemAdministrationService.findAllPluginsAtStart());
            dto.setWhiteList(this.systemAdministrationService.findWhiteList());
            dto.setUploadSizeLimit(this.systemAdministrationService.findUploadSizeLimit());
            dto.setImportSizeLimit(this.systemAdministrationService.findImportSizeLimit());
            dto.setCallbackUrl(this.systemAdministrationService.findCallbackUrl());
            dto.setStackTracePanelIsVisible(this.stackTracePanelIsVisible.booleanValue());
            dto.setStackTraceFeatureIsEnabled(this.featureManager.isEnabled(FeatureManager.Feature.STACK_TRACE));
            dto.setAutoconnectOnConnection(this.featureManager.isEnabled(FeatureManager.Feature.AUTOCONNECT_ON_CONNECTION));
            dto.setCaseInsensitiveLogin(this.featureManager.isEnabled(FeatureManager.Feature.CASE_INSENSITIVE_LOGIN));
            dto.setDuplicateLogins(this.userManagerService.findAllDuplicateLogins());
            dto.setCaseInsensitiveActions(this.featureManager.isEnabled(FeatureManager.Feature.CASE_INSENSITIVE_ACTIONS));
            dto.setDuplicateActions(this.actionWordLibraryNodeService.findAllCaseInsensitiveDuplicateActions());
            dto.setWelcomeMessage(this.systemAdministrationService.findWelcomeMessage());
            dto.setLoginMessage(this.systemAdministrationService.findLoginMessage());
            dto.setBannerMessage(this.systemAdministrationService.findBannerMessage());
            dto.setLogFiles(this.logFileDownloadService.getAllPreviousLogFileNames());
            dto.setLicenseInfo(this.systemAdministrationService.getBasicLicenseInfo());
            dto.setReportTemplateModels(this.getTemplateModels());
            dto.setUnsafeAttachmentPreviewEnabled(this.featureManager.isEnabled(FeatureManager.Feature.UNSAFE_ATTACHMENT_PREVIEW));
        }
        this.appendSyncPluginsInfo(currentUser, dto);
        return dto;
    }

    private void appendSyncPluginsInfo(UserDto currentUser, SystemViewDto systemViewDto) {
        ArrayList syncPluginDtos = new ArrayList();
        if (!this.synchronisationPlugins.isEmpty()) {
            List manageableProjectIds = this.customProjectFinder.findAllManageableIds(currentUser);
            if (!currentUser.isAdmin() && manageableProjectIds.isEmpty()) {
                throw new AccessDeniedException("No projects are manageable");
            }
            this.synchronisationPlugins.forEach(syncPlugin -> {
                SynchronisationPluginViewDto syncPluginDto = new SynchronisationPluginViewDto();
                syncPluginDto.setId(syncPlugin.getId());
                syncPluginDto.setName(syncPlugin.getName());
                syncPluginDto.setRemoteSynchronisations(this.findRemoteSynchronisationsForPlugin(manageableProjectIds, syncPlugin));
                syncPluginDto.setHasSupervisionScreen(syncPlugin.hasSupervisionScreen());
                syncPluginDto.setSupervisionScreenData(syncPlugin.getSupervisionScreenData());
                syncPluginDtos.add(syncPluginDto);
            });
        }
        systemViewDto.setSynchronisationPlugins(syncPluginDtos);
    }

    @GetMapping(value={"/current-active-users-count"})
    public Map<String, Integer> getCurrentActiveUsersCount() {
        HashMap<String, Integer> responseBody = new HashMap<String, Integer>();
        int currentActiveUsersCount = this.userManagerService.countAllActiveUsers();
        responseBody.put("currentActiveUsersCount", currentActiveUsersCount);
        return responseBody;
    }

    private List<ReportTemplateModel> getTemplateModels() {
        ArrayList<ReportTemplateModel> reportTemplateModels = new ArrayList<ReportTemplateModel>();
        this.reportsRegistry.getSortedReports().stream().filter(IdentifiedReportDecorator::isDocxTemplate).forEach(reportDecorator -> {
            DocxTemplaterReport docxTemplaterReport = (DocxTemplaterReport)reportDecorator.getReport();
            List models = this.findTemplateModelsFromFolderPath(reportDecorator.getNamespace(), docxTemplaterReport.getCustomTemplateFolderPath());
            reportTemplateModels.addAll(models);
        });
        return reportTemplateModels;
    }

    private List<ReportTemplateModel> findTemplateModelsFromFolderPath(String namespace, @NotNull String folderPath) {
        File[] customTemplates = new File(folderPath).listFiles();
        if (customTemplates != null) {
            return Stream.of(customTemplates).filter(customTemplate -> !customTemplate.isDirectory()).map(File::getName).filter(customTemplateName -> "docx".equals(FilenameUtils.getExtension((String)customTemplateName))).map(fileName -> new ReportTemplateModel(namespace, fileName)).collect(Collectors.toList());
        }
        return new ArrayList<ReportTemplateModel>();
    }

    private List<RemoteSynchronisationDto> findRemoteSynchronisationsForPlugin(List<Long> manageableProjectIds, SynchronisationPlugin plugin) {
        List synchronisations = this.systemAdministrationService.findRemoteSynchronisationForPlugin(manageableProjectIds, plugin.getId());
        List<RemoteSynchronisationDto> synchronisationDtos = synchronisations.stream().map(arg_0 -> this.transformRemoteSynchronisationInDto(arg_0)).collect(Collectors.toList());
        this.appendErrorLogFilePath(synchronisationDtos, plugin);
        return synchronisationDtos;
    }

    private void appendErrorLogFilePath(List<RemoteSynchronisationDto> synchronisationDtos, SynchronisationPlugin plugin) {
        synchronisationDtos.forEach(syncDto -> {
            String syncErrorLogFilePath = plugin.getSyncErrorLogPath(Long.valueOf(syncDto.getId()));
            File file = new File(syncErrorLogFilePath);
            if (file.exists()) {
                syncDto.setSyncErrorLogFilePath(syncErrorLogFilePath);
            }
        });
    }

    private RemoteSynchronisationDto transformRemoteSynchronisationInDto(RemoteSynchronisation remoteSync) {
        return new RemoteSynchronisationDto(remoteSync);
    }
}

