/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.sprint;

import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.display.sprint.SprintDisplayService;
import org.squashtest.tm.service.display.testplan.SprintTestPlanDisplayService;
import org.squashtest.tm.service.internal.display.dto.sprint.SprintDto;
import org.squashtest.tm.service.internal.display.dto.sprint.SprintReqVersionDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;

@RestController
@RequestMapping(value={"/backend/sprint-view"})
public class SprintViewController {
    private final SprintDisplayService sprintDisplayService;
    private final SprintTestPlanDisplayService sprintTestPlanDisplayService;

    public SprintViewController(SprintDisplayService sprintDisplayService, SprintTestPlanDisplayService sprintTestPlanDisplayService) {
        this.sprintDisplayService = sprintDisplayService;
        this.sprintTestPlanDisplayService = sprintTestPlanDisplayService;
    }

    @GetMapping(value={"/{sprintId}"})
    public SprintDto getSprintView(@PathVariable long sprintId) {
        return this.sprintDisplayService.getSprintView(sprintId);
    }

    @GetMapping(value={"/{sprintId}/sprintReqVersions"})
    public List<SprintReqVersionDto> getSprintReqVersionDtos(@PathVariable long sprintId) {
        return this.sprintDisplayService.findSprintReqVersionDtosBySprintId(sprintId);
    }

    @PostMapping(value={"{sprintId}/overall-exec-plan"})
    public GridResponse findOverallSprintExecutionPlan(@PathVariable long sprintId, @RequestBody GridRequest gridRequest) {
        return this.sprintTestPlanDisplayService.findSprintOverallExecPlan(sprintId, gridRequest);
    }
}

