/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.requirement;

import java.util.List;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.service.display.requirements.RequirementDisplayService;
import org.squashtest.tm.service.internal.display.dto.MilestoneDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;
import org.squashtest.tm.web.backend.controller.requirement.RequirementVersionModificationController;

@RestController
@RequestMapping(value={"backend/requirement-version/{requirementVersionId}"})
public class RequirementVersionModificationController {
    private final RequirementVersionManagerService requirementVersionManager;
    private final RequirementDisplayService requirementDisplayService;

    public RequirementVersionModificationController(RequirementVersionManagerService requirementVersionManager, RequirementDisplayService requirementDisplayService) {
        this.requirementVersionManager = requirementVersionManager;
        this.requirementDisplayService = requirementDisplayService;
    }

    @PostMapping(value={"/history"})
    public GridResponse getHistory(@PathVariable Long requirementVersionId, @RequestBody GridRequest requestParam) {
        return this.requirementDisplayService.findCurrentVersionModificationHistoryByRequirementVersionId(requirementVersionId, requestParam);
    }

    @PostMapping(value={"/name"})
    public void rename(@PathVariable Long requirementVersionId, @RequestBody RequirementVersionPatch patch) {
        this.requirementVersionManager.rename(requirementVersionId.longValue(), patch.getName());
    }

    @PostMapping(value={"/reference"})
    public void changeReference(@PathVariable Long requirementVersionId, @RequestBody RequirementVersionPatch patch) {
        this.requirementVersionManager.changeReference(requirementVersionId.longValue(), patch.getReference());
    }

    @PostMapping(value={"/description"})
    public void changeDescription(@PathVariable Long requirementVersionId, @RequestBody RequirementVersionPatch patch) {
        this.requirementVersionManager.changeDescription(requirementVersionId.longValue(), patch.getDescription());
    }

    @PostMapping(value={"/category"})
    public void changeCategory(@PathVariable Long requirementVersionId, @RequestBody RequirementVersionPatch patch) {
        this.requirementVersionManager.changeCategory(requirementVersionId.longValue(), patch.getCategory());
    }

    @PostMapping(value={"/criticality"})
    public void changeCriticality(@PathVariable Long requirementVersionId, @RequestBody RequirementVersionPatch patch) {
        this.requirementVersionManager.changeCriticality(requirementVersionId.longValue(), RequirementCriticality.valueOf((String)patch.getCriticality()));
    }

    @PostMapping(value={"/status"})
    public void changeStatus(@PathVariable Long requirementVersionId, @RequestBody RequirementVersionPatch patch) {
        this.requirementVersionManager.changeStatus(requirementVersionId.longValue(), RequirementStatus.valueOf((String)patch.getStatus()));
    }

    @RequestMapping(value={"/milestones/{milestoneIds}"}, method={RequestMethod.POST})
    public List<MilestoneDto> bindMilestones(@PathVariable long requirementVersionId, @PathVariable(value="milestoneIds") List<Long> milestoneIds) {
        this.requirementVersionManager.bindMilestones(requirementVersionId, milestoneIds);
        return this.requirementDisplayService.findBindableMilestones(Long.valueOf(requirementVersionId));
    }

    @RequestMapping(value={"/milestones/{milestoneIds}"}, method={RequestMethod.DELETE})
    public List<MilestoneDto> unbindMilestones(@PathVariable long requirementVersionId, @PathVariable List<Long> milestoneIds) {
        this.requirementVersionManager.unbindMilestones(requirementVersionId, milestoneIds);
        return this.requirementDisplayService.findBindableMilestones(Long.valueOf(requirementVersionId));
    }
}

