/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.report;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.api.report.Report;
import org.squashtest.tm.api.utils.CurrentUserHelper;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.report.ReportModificationService;
import org.squashtest.tm.web.backend.controller.report.ReportDefinitionViewController;
import org.squashtest.tm.web.backend.helper.JsonHelper;
import org.squashtest.tm.web.backend.helper.ReportHelper;
import org.squashtest.tm.web.backend.report.IdentifiedReportDecorator;
import org.squashtest.tm.web.backend.report.ReportsRegistry;
import org.squashtest.tm.web.backend.report.criteria.ConciseFormToCriteriaConverter;

@RestController
@RequestMapping(value={"backend/report-definition-view"})
public class ReportDefinitionViewController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportDefinitionViewController.class);
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    private final ReportModificationService reportModificationService;
    private final ReportsRegistry reportsRegistry;
    private final ReportHelper reportHelper;
    private final ProjectFinder projectFinder;
    private final CurrentUserHelper currentUserHelper;

    public ReportDefinitionViewController(CustomReportLibraryNodeService customReportLibraryNodeService, ReportModificationService reportModificationService, ReportsRegistry reportsRegistry, ReportHelper reportHelper, ProjectFinder projectFinder, CurrentUserHelper currentUserHelper) {
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.reportModificationService = reportModificationService;
        this.reportsRegistry = reportsRegistry;
        this.reportHelper = reportHelper;
        this.projectFinder = projectFinder;
        this.currentUserHelper = currentUserHelper;
    }

    @RequestMapping(value={"/{customReportLibraryNodeId}"}, method={RequestMethod.GET})
    public ReportDefinitionViewModel getReportDefinitionViewModel(@PathVariable Long customReportLibraryNodeId) {
        ReportDefinition reportDefinition = this.customReportLibraryNodeService.findReportDefinitionByNodeId(customReportLibraryNodeId);
        return this.getViewModelFromDefinition(reportDefinition, customReportLibraryNodeId);
    }

    @RequestMapping(value={"/report-definition/{reportDefinitionId}"})
    public ReportDefinitionViewModel getReportDefinitionViewModelByReportId(@PathVariable Long reportDefinitionId) {
        ReportDefinition reportDefinition = this.reportModificationService.findById(reportDefinitionId.longValue());
        return this.getViewModelFromDefinition(reportDefinition, null);
    }

    private ReportDefinitionViewModel getViewModelFromDefinition(ReportDefinition reportDefinition, Long customReportLibraryNodeId) {
        IdentifiedReportDecorator report = this.reportsRegistry.findReport(reportDefinition.getPluginNamespace());
        if (Objects.nonNull(report)) {
            Map form = null;
            try {
                form = JsonHelper.deserialize((String)reportDefinition.getParameters());
            }
            catch (IOException e) {
                LOGGER.error("the report : " + reportDefinition.getName() + " has corrupted parameters.", (Throwable)e);
            }
            List readableProjectIds = this.currentUserHelper.findReadableProjectIds();
            List projectIds = this.projectFinder.findAllProjectIdsOrderedByName(readableProjectIds);
            Map crit = new ConciseFormToCriteriaConverter((Report)report, projectIds).convert(form);
            return new ReportDefinitionViewModel(reportDefinition, customReportLibraryNodeId, this.reportHelper.getAttributesForReport((Report)report, crit, projectIds), report);
        }
        return new ReportDefinitionViewModel(reportDefinition, customReportLibraryNodeId);
    }
}

