/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.referential;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.display.referential.ReferentialDataProvider;
import org.squashtest.tm.service.internal.display.referential.AdminReferentialData;
import org.squashtest.tm.service.internal.display.referential.ReferentialData;
import org.squashtest.tm.service.internal.display.referential.SynchronisationPluginDto;
import org.squashtest.tm.service.internal.display.referential.WorkspaceWizardDto;
import org.squashtest.tm.web.backend.manager.synchronisation.SynchronisationPluginManager;
import org.squashtest.tm.web.backend.manager.wizard.WorkspaceWizardManager;
import org.squashtest.tm.web.backend.report.IdentifiedReportDecorator;
import org.squashtest.tm.web.backend.report.ReportsRegistry;

@RestController
@RequestMapping(value={"backend/referential"})
public class ReferentialDataController {
    private final ReferentialDataProvider referentialDataProvider;
    private final WorkspaceWizardManager workspaceWizardManager;
    private final SynchronisationPluginManager synchronisationPluginManager;
    private final ReportsRegistry reportsRegistry;

    public ReferentialDataController(ReferentialDataProvider referentialDataProvider, ReportsRegistry reportsRegistry, WorkspaceWizardManager workspaceWizardManager, SynchronisationPluginManager synchronisationPluginManager) {
        this.referentialDataProvider = referentialDataProvider;
        this.workspaceWizardManager = workspaceWizardManager;
        this.reportsRegistry = reportsRegistry;
        this.synchronisationPluginManager = synchronisationPluginManager;
    }

    @GetMapping
    public ReferentialData get() {
        ReferentialData referentialData = this.referentialDataProvider.findReferentialData();
        this.appendWorkspaceWizards(referentialData);
        this.appendSynchronisationPlugins(referentialData);
        return referentialData;
    }

    private void appendWorkspaceWizards(ReferentialData referentialData) {
        List workspaceWizards = this.workspaceWizardManager.findAll().stream().map(WorkspaceWizardDto::fromWorkspaceWizard).collect(Collectors.toList());
        referentialData.setWorkspaceWizards(workspaceWizards);
    }

    private void appendSynchronisationPlugins(ReferentialData referentialData) {
        List synchronisationPlugins = this.synchronisationPluginManager.findAll().stream().map(SynchronisationPluginDto::fromSynchronizationPlugin).collect(Collectors.toList());
        referentialData.setSynchronizationPlugins(synchronisationPlugins);
    }

    @GetMapping(path={"/admin"})
    public AdminReferentialData getAdminReferentialData() {
        AdminReferentialData referentialData = this.referentialDataProvider.findAdminReferentialData();
        this.setAvailableReports(referentialData);
        this.appendSynchronisationPlugins(referentialData);
        return referentialData;
    }

    private void setAvailableReports(AdminReferentialData referentialData) {
        List<String> availableTemplatableReportIds = this.reportsRegistry.getSortedReports().stream().filter(IdentifiedReportDecorator::isDocxTemplate).map(IdentifiedReportDecorator::extractReportDataId).toList();
        referentialData.setAvailableReportIds(availableTemplatableReportIds);
    }

    private void appendSynchronisationPlugins(AdminReferentialData referentialData) {
        List synchronisationPlugins = this.synchronisationPluginManager.findAll().stream().map(SynchronisationPluginDto::fromSynchronizationPlugin).collect(Collectors.toList());
        referentialData.setSynchronizationPlugins(synchronisationPlugins);
    }
}

