/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.squashtest.tm.api.plugin.ConfigurablePlugin;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.projectimporter.PivotFormatImportType;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.service.display.project.ProjectDisplayService;
import org.squashtest.tm.service.internal.display.dto.PartyProjectPermissionDto;
import org.squashtest.tm.service.internal.display.dto.PivotFormatImportDto;
import org.squashtest.tm.service.internal.display.dto.ProjectDataInfo;
import org.squashtest.tm.service.internal.display.dto.ProjectDto;
import org.squashtest.tm.service.internal.display.dto.TestAutomationProjectDto;
import org.squashtest.tm.service.internal.display.dto.party.UnboundPartiesResponse;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.dto.projectimporterxray.model.XrayImportModel;
import org.squashtest.tm.service.internal.dto.projectimporterxray.model.XrayInfoModel;
import org.squashtest.tm.service.project.CustomGenericProjectManager;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.projectimporter.pivotimporter.GlobalProjectPivotImporterService;
import org.squashtest.tm.service.projectimporter.xrayimporter.GlobalProjectXrayImporterService;
import org.squashtest.tm.service.testautomation.TestAutomationProjectManagerService;
import org.squashtest.tm.web.backend.controller.project.GenericProjectController;
import org.squashtest.tm.web.backend.manager.plugin.ConfigurablePluginManager;

@RestController
@RequestMapping(value={"/backend/generic-projects"})
public class GenericProjectController {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericProjectController.class);
    private final ProjectDisplayService projectDisplayService;
    private final CustomGenericProjectManager customGenericProjectManager;
    private final GenericProjectManagerService genericProjectManagerService;
    private final TaskExecutor taskExecutor;
    private final TestAutomationProjectManagerService testAutomationProjectService;
    private final ConfigurablePluginManager configurablePluginManager;
    private final GlobalProjectPivotImporterService projectImporterService;
    private final GlobalProjectXrayImporterService projectImporterXrayService;

    @Inject
    public GenericProjectController(ProjectDisplayService projectDisplayService, GenericProjectManagerService projectManager, CustomGenericProjectManager projectManagerService, TaskExecutor taskExecutor, TestAutomationProjectManagerService testAutomationProjectService, ConfigurablePluginManager configurablePluginManager, GlobalProjectPivotImporterService projectImporterService, GlobalProjectXrayImporterService projectImporterXrayService) {
        this.projectDisplayService = projectDisplayService;
        this.genericProjectManagerService = projectManager;
        this.customGenericProjectManager = projectManagerService;
        this.taskExecutor = taskExecutor;
        this.testAutomationProjectService = testAutomationProjectService;
        this.configurablePluginManager = configurablePluginManager;
        this.projectImporterService = projectImporterService;
        this.projectImporterXrayService = projectImporterXrayService;
    }

    @RequestMapping(method={RequestMethod.POST})
    public GridResponse getProjects(@RequestBody GridRequest request) {
        return this.projectDisplayService.findAll(request);
    }

    @RequestMapping(value={"/templates"}, method={RequestMethod.GET})
    public Map<String, Object> getTemplates() {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("templates", this.projectDisplayService.getTemplateNamedReferences());
        return response;
    }

    @PostMapping(value={"/{projectId}/permissions/{partyIds}/group/{groupId}"})
    public Map<String, List<PartyProjectPermissionDto>> addNewPartyPermissions(@PathVariable long projectId, @PathVariable List<Long> partyIds, @PathVariable long groupId) {
        this.customGenericProjectManager.addNewPermissionToProject(partyIds, projectId, groupId);
        return Collections.singletonMap("partyProjectPermissions", this.projectDisplayService.getPartyProjectPermissions(Long.valueOf(projectId)));
    }

    @DeleteMapping(value={"/{projectId}/permissions/{partyIds}"})
    public void removePartyPermissions(@PathVariable long projectId, @PathVariable List<Long> partyIds) {
        this.customGenericProjectManager.removeProjectPermission(partyIds, projectId);
    }

    @RequestMapping(value={"/{projectId}/bugtracker"}, method={RequestMethod.POST})
    public void changeBugtracker(@PathVariable long projectId, @RequestBody Map<String, Long> request) {
        if (request.get("bugtrackerId") != null) {
            this.genericProjectManagerService.changeBugTracker(projectId, request.get("bugtrackerId"));
        } else {
            this.genericProjectManagerService.removeBugTracker(projectId);
        }
    }

    @RequestMapping(value={"/{projectId}/ai-server"}, method={RequestMethod.POST})
    public void changeAiServer(@PathVariable long projectId, @RequestBody Map<String, Long> request) {
        if (request.get("aiServerId") != null) {
            this.genericProjectManagerService.changeAiServer(projectId, request.get("aiServerId").longValue());
        } else {
            this.genericProjectManagerService.unbindAiServer(projectId);
        }
    }

    @RequestMapping(value={"/{projectId}/name"}, method={RequestMethod.POST})
    public void changeName(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        this.genericProjectManagerService.changeName(projectId, patch.getName());
    }

    @RequestMapping(value={"/{projectId}/description"}, method={RequestMethod.POST})
    public void changeDescription(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        this.genericProjectManagerService.changeDescription(projectId, patch.getDescription());
    }

    @RequestMapping(value={"/{projectId}/label"}, method={RequestMethod.POST})
    public void changeLabel(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        this.genericProjectManagerService.changeLabel(projectId, patch.getLabel());
    }

    @PostMapping(value={"/{projectId}/linked-template-id"})
    public ProjectDto associateTemplate(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        Long templateId = patch.getLinkedTemplateId();
        if (templateId == null) {
            this.genericProjectManagerService.disassociateFromTemplate(projectId);
        } else {
            this.genericProjectManagerService.associateToTemplate(projectId, templateId.longValue(), patch.getBoundTemplatePlugins());
        }
        return this.projectDisplayService.getProjectView(projectId);
    }

    @PostMapping(value={"/{projectId}/automation-workflow-type"})
    public void changeAutomationWorkflowType(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        this.genericProjectManagerService.changeAutomationWorkflow(projectId, patch.getAutomationWorkflowType());
    }

    @PostMapping(value={"/{projectId}/bdd-implementation-technology"})
    public void changeBddImplementationTechnology(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        this.genericProjectManagerService.changeBddImplTechnology(projectId, patch.getBddImplementationTechnology());
    }

    @PostMapping(value={"/{projectId}/bdd-script-language"})
    public void changeBddScriptLanguage(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        this.genericProjectManagerService.changeBddScriptLanguage(projectId, patch.getBddScriptLanguage());
    }

    @PostMapping(value={"/{projectId}/scm-repository-id"})
    public void changeScmServer(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        Long repositoryId = patch.getScmRepositoryId();
        if (repositoryId == null) {
            this.genericProjectManagerService.unbindScmRepository(projectId);
        } else {
            this.genericProjectManagerService.bindScmRepository(projectId, repositoryId.longValue());
        }
    }

    @PostMapping(value={"/{projectId}/use-tree-structure-in-scm-repo"})
    public void changeUseTreeStructureInScmRepo(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        this.genericProjectManagerService.changeUseTreeStructureInScmRepo(projectId, patch.isUseTreeStructureInScmRepo());
    }

    @PostMapping(value={"/{projectId}/ta-server-id"})
    public void changeTestAutomationServer(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        this.genericProjectManagerService.bindTestAutomationServer(projectId, patch.getTaServerId());
    }

    @PostMapping(value={"/{projectId}/automated-suites-lifetime"})
    public void changeAutomatedSuitesLifetime(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        this.genericProjectManagerService.changeAutomatedSuitesLifetime(projectId, patch.getAutomatedSuitesLifetime());
    }

    @PostMapping(value={"/{projectId}/test-automation-projects/new"})
    public Map<String, List<TestAutomationProjectDto>> addTestAutomationProject(@PathVariable long projectId, @RequestBody Map<String, TestAutomationProjectDto[]> request) {
        List taProjects = Arrays.stream(request.get("taProjects")).map(projectDto -> {
            TestAutomationProject taProject = new TestAutomationProject();
            taProject.setJobName(projectDto.getRemoteName());
            taProject.setCanRunGherkin(projectDto.isCanRunBdd());
            taProject.setLabel(projectDto.getLabel());
            return taProject;
        }).collect(Collectors.toList());
        this.genericProjectManagerService.bindTestAutomationProjects(projectId, taProjects);
        return Collections.singletonMap("taProjects", this.testAutomationProjectService.findAllByTMProject(projectId));
    }

    @RequestMapping(value={"/{projectId}/allow-tc-modif-during-exec"})
    public void changeAllowTcModifDuringExec(@PathVariable long projectId, @RequestBody ProjectPatch patch) {
        this.genericProjectManagerService.changeAllowTcModifDuringExec(projectId, patch.isAllowTcModifDuringExec());
    }

    @RequestMapping(value={"/{projectId}/change-execution-status/{executionStatus}"}, method={RequestMethod.POST})
    public void changeExecutionStatusOnProject(@PathVariable long projectId, @PathVariable String executionStatus, @RequestBody Map<String, Boolean> patch) {
        if (Boolean.TRUE.equals(patch.get(executionStatus.toUpperCase()))) {
            this.genericProjectManagerService.enableExecutionStatus(projectId, ExecutionStatus.valueOf((String)executionStatus));
        } else {
            this.genericProjectManagerService.disableExecutionStatus(projectId, ExecutionStatus.valueOf((String)executionStatus));
        }
    }

    @RequestMapping(value={"/{projectId}/disable-and-replace-execution-status-within-project/{sourceExecutionStatus}"}, method={RequestMethod.POST})
    public void disableAndReplaceStatusWithinProject(@PathVariable long projectId, @PathVariable String sourceExecutionStatus, @RequestBody Map<String, String> targetExecutionStatus) {
        this.genericProjectManagerService.disableExecutionStatus(projectId, ExecutionStatus.valueOf((String)sourceExecutionStatus));
        ExecutionStatus source = ExecutionStatus.valueOf((String)sourceExecutionStatus);
        ExecutionStatus target = ExecutionStatus.valueOf((String)targetExecutionStatus.get("targetExecutionStatus"));
        AsynchronousReplaceExecutionStatus replacer = new AsynchronousReplaceExecutionStatus(this, Long.valueOf(projectId), source, target);
        this.taskExecutor.execute((Runnable)replacer);
    }

    @RequestMapping(value={"/{projectId}/get-enabled-execution-status/{executionStatus}"}, method={RequestMethod.GET})
    public Map<String, Object> getEnabledExecutionStatus(@PathVariable long projectId, @PathVariable String executionStatus) {
        Set statuses = this.genericProjectManagerService.enabledExecutionStatuses(projectId);
        ExecutionStatus status = ExecutionStatus.valueOf((String)executionStatus);
        statuses.remove(status);
        ArrayList options = new ArrayList();
        for (ExecutionStatus st : statuses) {
            HashMap<String, String> statusOption = new HashMap<String, String>();
            statusOption.put("label", st.getI18nKey());
            statusOption.put("id", st.name());
            options.add(statusOption);
        }
        return Collections.singletonMap("statuses", options);
    }

    @RequestMapping(value={"/{projectId}/plugins/{pluginId}"}, method={RequestMethod.POST})
    public Map<String, Boolean> enablePlugin(@PathVariable long projectId, @PathVariable String pluginId) {
        Optional plugin = this.configurablePluginManager.findById(pluginId);
        if (plugin.isPresent()) {
            this.genericProjectManagerService.enablePlugin(projectId, (ConfigurablePlugin)plugin.get());
            boolean hasConfiguration = this.genericProjectManagerService.pluginHasConfigurationOrSynchronisations((ConfigurablePlugin)plugin.get(), projectId);
            boolean isValid = this.configurablePluginManager.isPluginBindingValid(pluginId, projectId);
            return Collections.singletonMap("hasValidConfiguration", hasConfiguration && isValid);
        }
        throw new IllegalArgumentException("Cannot find configurable plugin with ID " + pluginId);
    }

    @RequestMapping(value={"/{projectId}/plugins/{pluginId}"}, method={RequestMethod.DELETE}, params={"saveConf"})
    @Transactional
    public void disablePlugin(@PathVariable long projectId, @PathVariable String pluginId, @RequestParam(value="saveConf") Boolean saveConf) {
        Optional plugin = this.configurablePluginManager.findById(pluginId);
        if (!plugin.isPresent()) {
            throw new IllegalArgumentException("Cannot find configurable plugin with ID " + pluginId);
        }
        this.configurablePluginManager.disableConfigurablePlugin(pluginId, projectId, saveConf);
    }

    @PostMapping(value={"/{projectId}/has-data"})
    public ProjectDataInfo getProjectDataInfoOnAction(@PathVariable Long projectId, @RequestBody Map<String, String> request) {
        ProjectDataInfo.ProjectAction action = ProjectDataInfo.ProjectAction.DELETION.name().equals(request.get("action")) ? ProjectDataInfo.ProjectAction.DELETION : ProjectDataInfo.ProjectAction.TRANSFORMATION;
        return this.projectDisplayService.getProjectDataInfoOnAction(projectId, action);
    }

    @PostMapping(value={"/{projectId}/create-import-request"}, produces={"application/json"})
    @ResponseBody
    public Map<String, List<PivotFormatImportDto>> importProject(@PathVariable long projectId, @RequestParam(value="archive") MultipartFile archive, @RequestParam(value="importName") String importName, @RequestParam(value="importType") PivotFormatImportType importType) {
        this.projectImporterService.createImportRequest(projectId, archive, importName, importType);
        return Collections.singletonMap("existingImports", this.projectDisplayService.getExistingImports(projectId));
    }

    @DeleteMapping(value={"/{projectId}/delete-import-request/{importIds}"}, produces={"application/json"})
    public void deleteImportProject(@PathVariable long projectId, @PathVariable List<Long> importIds) {
        this.projectImporterService.deleteImportRequests(projectId, importIds);
    }

    @PostMapping(value={"/{projectId}/info-from-xray-xml"})
    public XrayInfoModel getInfoFromXrayXml(@PathVariable long projectId, @RequestParam(value="archive") MultipartFile[] archives) throws IOException {
        return this.projectImporterXrayService.generateXrayInfoDtoFromXml(projectId, archives);
    }

    @PostMapping(value={"/{projectId}/import-from-xray-xml"})
    public XrayImportModel importProjectXray(@PathVariable long projectId, @RequestParam(value="archive") MultipartFile[] archives) throws IOException {
        return this.projectImporterXrayService.generatePivotFromXml(projectId, archives);
    }

    @GetMapping(value={"/{projectId}/import-from-xray-xml/{filename:.+}"})
    public FileSystemResource getPivotFileFromXray(@PathVariable long projectId, @PathVariable String filename, HttpServletResponse response) {
        try {
            File pivotFile = this.projectImporterXrayService.verifyXrayFile(projectId, filename);
            FileSystemResource fileSystemResource = new FileSystemResource(pivotFile);
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename=" + pivotFile.getName());
            return fileSystemResource;
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Error downloading pivot file", (Throwable)e);
            response.setStatus(403);
            return null;
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Error downloading pivot file", (Throwable)e);
            response.setStatus(400);
            return null;
        }
    }

    @DeleteMapping(value={"/{projectId}/import-from-xray-xml"}, params={"pivotFile", "pivotLog"})
    public void deletePivotFileFromXray(@PathVariable Long projectId, @RequestParam(value="pivotFile") String pivotFileName, @RequestParam(value="pivotLog") String pivotLogName, HttpServletResponse response) {
        try {
            FileUtils.deleteQuietly((File)this.projectImporterXrayService.verifyXrayFile(projectId.longValue(), pivotFileName));
            FileUtils.deleteQuietly((File)this.projectImporterXrayService.verifyXrayFile(projectId.longValue(), pivotLogName));
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Error during the cleanup of temporary pivot files", (Throwable)e);
            response.setStatus(403);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Error during the cleanup of temporary pivot files", (Throwable)e);
            response.setStatus(400);
        }
    }

    @GetMapping(value={"/{genericProjectId}/unbound-parties"})
    public UnboundPartiesResponse getUnboundParties(@PathVariable long genericProjectId) {
        return this.genericProjectManagerService.findPartyWithoutPermissionByProject(genericProjectId);
    }
}

