/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.infolist;

import java.util.List;
import javax.inject.Inject;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.display.infolist.InfoListDisplayService;
import org.squashtest.tm.service.infolist.InfoListItemManagerService;
import org.squashtest.tm.service.infolist.InfoListManagerService;
import org.squashtest.tm.service.internal.display.dto.InfoListAdminViewDto;
import org.squashtest.tm.web.backend.controller.infolist.InfoListItemController;

@RestController
@RequestMapping(value={"/backend/info-list-items"})
public class InfoListItemController {
    InfoListItemManagerService infoListItemManagerService;
    InfoListManagerService infoListManagerService;
    InfoListDisplayService infoListDisplayService;

    @Inject
    InfoListItemController(InfoListItemManagerService infoListItemManagerService, InfoListManagerService infoListManagerService, InfoListDisplayService infoListDisplayService) {
        this.infoListItemManagerService = infoListItemManagerService;
        this.infoListManagerService = infoListManagerService;
        this.infoListDisplayService = infoListDisplayService;
    }

    @RequestMapping(value={"/{infoListItemId}/label"}, method={RequestMethod.POST})
    public void changeLabel(@PathVariable long infoListItemId, @RequestBody InfoListItemPatch patch) {
        this.infoListItemManagerService.changeLabel(infoListItemId, patch.getLabel());
    }

    @RequestMapping(value={"/{infoListItemId}/code"}, method={RequestMethod.POST})
    public void changeCode(@PathVariable long infoListItemId, @RequestBody InfoListItemPatch patch) {
        this.infoListItemManagerService.changeCode(infoListItemId, patch.getCode());
    }

    @RequestMapping(value={"/{infoListItemId}/colour"}, method={RequestMethod.POST})
    public void changeColour(@PathVariable long infoListItemId, @RequestBody InfoListItemPatch patch) {
        this.infoListItemManagerService.changeColour(infoListItemId, patch.getColour());
    }

    @RequestMapping(value={"/{infoListItemId}/default"}, method={RequestMethod.POST})
    public void setDefault(@PathVariable long infoListItemId) {
        this.infoListItemManagerService.changeDefault(infoListItemId);
    }

    @RequestMapping(value={"/{infoListItemId}/icon-name"}, method={RequestMethod.POST})
    public void changeIcon(@PathVariable long infoListItemId, @RequestBody InfoListItemPatch patch) {
        this.infoListItemManagerService.changeIcon(infoListItemId, patch.getIconName());
    }

    @RequestMapping(value={"/{infoListId}/items/{infoListItemIds}"}, method={RequestMethod.DELETE})
    public void deleteInfoListItem(@PathVariable long infoListId, @PathVariable List<Long> infoListItemIds) {
        this.infoListItemManagerService.removeInfoListItems(infoListItemIds, infoListId);
    }

    @RequestMapping(value={"/{infoListId}/items/positions"}, method={RequestMethod.POST})
    public InfoListAdminViewDto changeOptionsPositions(@PathVariable long infoListId, @RequestBody ReorderOptionsRequestBody requestBody) {
        this.infoListManagerService.changeItemsPositions(infoListId, requestBody.getPosition().intValue(), requestBody.getInfoListItemIds());
        return this.infoListDisplayService.getInfoListView(infoListId);
    }
}

