/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.infolist;

import java.util.Map;
import javax.inject.Inject;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.infolist.InfoListBindingManagerService;

@RestController
@RequestMapping(value={"/backend/info-list-binding"})
public class InfoListBindingController {
    private static final String INFO_LIST_ID = "infoListId";
    private final InfoListBindingManagerService infoListBindingManagerService;

    @Inject
    InfoListBindingController(InfoListBindingManagerService infoListBindingManagerService) {
        this.infoListBindingManagerService = infoListBindingManagerService;
    }

    @RequestMapping(value={"/project/{projectId}/category"}, method={RequestMethod.POST})
    public void bindCategoryToProject(@PathVariable Long projectId, @RequestBody Map<String, Long> request) {
        this.infoListBindingManagerService.bindListToProjectReqCategory(request.get(INFO_LIST_ID).longValue(), projectId.longValue());
    }

    @RequestMapping(value={"/project/{projectId}/nature"}, method={RequestMethod.POST})
    public void bindNatureToProject(@PathVariable Long projectId, @RequestBody Map<String, Long> request) {
        this.infoListBindingManagerService.bindListToProjectTcNature(request.get(INFO_LIST_ID).longValue(), projectId.longValue());
    }

    @RequestMapping(value={"/project/{projectId}/type"}, method={RequestMethod.POST})
    public void bindTypeToProject(@PathVariable Long projectId, @RequestBody Map<String, Long> request) {
        this.infoListBindingManagerService.bindListToProjectTcType(request.get(INFO_LIST_ID).longValue(), projectId.longValue());
    }
}

