/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.importer.requirement;

import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.web.backend.controller.importer.ImportExcelResponse;
import org.squashtest.tm.web.backend.controller.importer.requirement.RequirementImportHelper;

@RestController
@RequestMapping(value={"backend/requirement/importer"})
public class RequirementImportController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementImportController.class);
    @Inject
    private RequirementLibraryNavigationService navigationService;
    @Inject
    private RequirementImportHelper importHelper;

    @RequestMapping(value={"/xls"}, method={RequestMethod.POST}, params={"dry-run"})
    public ImportExcelResponse dryRunExcelWorkbook(@RequestParam(value="archive") MultipartFile uploadedFile) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("dryRunExcelWorkbook");
        }
        return this.importHelper.importWorkbook("requirement", uploadedFile, xls -> this.navigationService.simulateImportExcelRequirement(xls));
    }

    @RequestMapping(value={"/xls"}, params={"!dry-run"}, method={RequestMethod.POST})
    public ImportExcelResponse importExcelWorkbook(@RequestParam(value="archive") MultipartFile uploadedFile) {
        return this.importHelper.importWorkbook("requirement", uploadedFile, xls -> this.navigationService.importExcelRequirement(xls));
    }
}

