/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.customreport;

import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Provider;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.customreport.CustomReportChartBinding;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.customreport.CustomReportReportBinding;
import org.squashtest.tm.service.customreport.CustomReportDashboardService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.display.customreport.DashboardDisplayService;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportChartBinding;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportReportBinding;
import org.squashtest.tm.web.backend.controller.customreport.DashboardModificationController;
import org.squashtest.tm.web.backend.model.builder.JsonCustomReportChartBindingBuilder;
import org.squashtest.tm.web.backend.model.builder.JsonCustomReportReportBindingBuilder;

@RestController
@RequestMapping(value={"/backend/dashboard"})
public class DashboardModificationController {
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    private final CustomReportDashboardService dashboardService;
    private final Provider<JsonCustomReportChartBindingBuilder> chartBindingBuilderProvider;
    private final Provider<JsonCustomReportReportBindingBuilder> reportBindingBuilderProvider;
    private final DashboardDisplayService dashboardDisplayService;

    public DashboardModificationController(CustomReportLibraryNodeService customReportLibraryNodeService, CustomReportDashboardService customReportDashboardService, Provider<JsonCustomReportChartBindingBuilder> chartBindingBuilderProvider, Provider<JsonCustomReportReportBindingBuilder> reportBindingBuilderProvider, DashboardDisplayService dashboardDisplayService) {
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.dashboardService = customReportDashboardService;
        this.chartBindingBuilderProvider = chartBindingBuilderProvider;
        this.reportBindingBuilderProvider = reportBindingBuilderProvider;
        this.dashboardDisplayService = dashboardDisplayService;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{dashboardEntityId}/name"})
    public void rename(@PathVariable long dashboardEntityId, @RequestBody DashboardPatch patch) {
        this.customReportLibraryNodeService.renameNode(Long.valueOf(dashboardEntityId), patch.getName(), CustomReportDashboard.class);
    }

    @RequestMapping(value={"/{dashboardEntityId}/chart-binding"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public JsonCustomReportChartBinding createChartBinding(@PathVariable long dashboardEntityId, @RequestBody ChartBindingForm formChartBinding) {
        CustomReportChartBinding chartBinding = formChartBinding.convertToEntity();
        this.dashboardService.bindChart(chartBinding, formChartBinding.getChartDefinitionNodeId(), Long.valueOf(dashboardEntityId));
        return ((JsonCustomReportChartBindingBuilder)this.chartBindingBuilderProvider.get()).build(chartBinding);
    }

    @RequestMapping(value={"/{dashboardEntityId}/report-binding"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public JsonCustomReportReportBinding createReportBinding(@PathVariable long dashboardEntityId, @RequestBody ReportBindingForm formReportBinding) {
        CustomReportReportBinding reportBinding = formReportBinding.convertToEntity();
        this.dashboardService.bindReport(reportBinding, formReportBinding.getReportDefinitionNodeId(), Long.valueOf(dashboardEntityId));
        return ((JsonCustomReportReportBindingBuilder)this.reportBindingBuilderProvider.get()).build(reportBinding);
    }

    @RequestMapping(value={"/chart-binding/{id}/swap/{chartNodeId}"}, method={RequestMethod.POST})
    public JsonCustomReportChartBinding swapChart(@PathVariable long id, @PathVariable long chartNodeId) {
        CustomReportChartBinding chartBinding = this.dashboardService.changeBindedChart(id, chartNodeId);
        return ((JsonCustomReportChartBindingBuilder)this.chartBindingBuilderProvider.get()).build(chartBinding);
    }

    @RequestMapping(value={"/report-binding/{id}/swap/{reportNodeId}"}, method={RequestMethod.POST})
    public JsonCustomReportReportBinding swapReport(@PathVariable long id, @PathVariable long reportNodeId) {
        CustomReportReportBinding reportBinding = this.dashboardService.changeBindedReport(id, reportNodeId);
        return ((JsonCustomReportReportBindingBuilder)this.reportBindingBuilderProvider.get()).build(reportBinding);
    }

    @RequestMapping(value={"/bindings"}, method={RequestMethod.POST})
    public void updateGrid(@RequestBody GridPositionUpdate gridElements) {
        List chartBindings = this.extractChartBindings(gridElements);
        List reportBindings = this.extractReportBindings(gridElements);
        this.dashboardService.updateGridPosition(chartBindings, reportBindings);
    }

    @RequestMapping(value={"/chart-binding/{id}"}, method={RequestMethod.DELETE})
    public void unbindChart(@PathVariable long id) {
        this.dashboardService.unbindChart(Long.valueOf(id));
    }

    @RequestMapping(value={"/report-binding/{id}"}, method={RequestMethod.DELETE})
    public void unbindReport(@PathVariable long id) {
        this.dashboardService.unbindReport(Long.valueOf(id));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/favorite/{workspace}/{dashboardId}"})
    public DashboardFavoriteWorkspaces changeFavoriteDashboard(@PathVariable long dashboardId, @PathVariable String workspace) {
        Workspace workspaceId = Workspace.valueOf((String)workspace);
        this.dashboardService.chooseFavoriteDashboardForCurrentUser(workspaceId, dashboardId);
        return new DashboardFavoriteWorkspaces(this.dashboardDisplayService.findFavoriteWorkspaceForDashboardAndCurrentUser(Long.valueOf(dashboardId)));
    }

    @DeleteMapping(value={"/favorite/{dashboardId}"})
    public void removeDashboardFromFavorites(@PathVariable long dashboardId) {
        this.dashboardService.removeDashboardFromFavoritesForCurrentUser(dashboardId);
    }

    @DeleteMapping(value={"/favorite/{workspace}/{dashboardId}"})
    public void removeDashboardFromFavoriteWithPreferenceKey(@PathVariable long dashboardId, @PathVariable String workspace) {
        Workspace workspaceId = Workspace.valueOf((String)workspace);
        this.dashboardService.removeDashboardFromFavoriteWithPreferenceKey(dashboardId, workspaceId);
    }

    private List<CustomReportReportBinding> extractReportBindings(GridPositionUpdate gridElements) {
        return gridElements.getReports().stream().map(ReportBindingForm::convertToEntity).collect(Collectors.toList());
    }

    private List<CustomReportChartBinding> extractChartBindings(GridPositionUpdate gridElements) {
        return gridElements.getCharts().stream().map(ChartBindingForm::convertToEntity).collect(Collectors.toList());
    }
}

