/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.customreport;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.NodeWorkspace;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.exception.library.RightsUnsuficientsForOperationException;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.display.workspace.tree.SingleHierarchyTreeBrowser;
import org.squashtest.tm.service.display.workspace.tree.TreeNodeCollectorService;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.TreeGridResponse;
import org.squashtest.tm.service.internal.display.grid.TreeRequest;
import org.squashtest.tm.web.backend.controller.form.model.CustomReportFolderFormModel;
import org.squashtest.tm.web.backend.controller.form.model.DashboardFormModel;
import org.squashtest.tm.web.backend.controller.form.model.EntityFormModelValidator;
import org.squashtest.tm.web.backend.controller.form.model.NodeList;
import org.squashtest.tm.web.backend.controller.form.model.NodeListAndWhiteList;
import org.squashtest.tm.web.backend.controller.form.model.RefreshTreeNodeModel;
import org.squashtest.tm.web.backend.controller.navigation.Messages;

@RestController
@RequestMapping(path={"backend/custom-report-tree"})
public class CustomReportLibraryNavigationController {
    public static final Logger LOGGER = LoggerFactory.getLogger(CustomReportLibraryNavigationController.class);
    private static final String ADD_DASHBOARD = "add-dashboard";
    private static final String ADD_CUSTOM_REPORT_FOLDER = "add-custom-report-folder";
    private final SingleHierarchyTreeBrowser treeBrowser;
    private final TreeNodeCollectorService treeNodeCollectorService;
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    private final MessageSource messageSource;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$squashtest$tm$domain$EntityType;

    public CustomReportLibraryNavigationController(SingleHierarchyTreeBrowser treeBrowser, TreeNodeCollectorService treeNodeCollectorService, CustomReportLibraryNodeService customReportLibraryNodeService, MessageSource messageSource) {
        this.treeBrowser = treeBrowser;
        this.treeNodeCollectorService = treeNodeCollectorService;
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.messageSource = messageSource;
    }

    @RequestMapping(method={RequestMethod.POST})
    public TreeGridResponse getInitialRows(@RequestBody TreeRequest treeRequest) {
        return this.treeBrowser.getInitialTree(NodeWorkspace.CUSTOM_REPORT, NodeReference.fromNodeIds((Collection)treeRequest.getOpenedNodes()), NodeReference.fromNodeIds((Collection)treeRequest.getSelectedNodes()));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{ids}/content"})
    public TreeGridResponse getChildren(@PathVariable List<String> ids) {
        Set nodeReference = NodeReference.fromNodeIds(ids);
        return this.treeBrowser.findSubHierarchy(nodeReference, new HashSet(nodeReference));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/refresh"})
    public TreeGridResponse refreshTree(@RequestBody RefreshTreeNodeModel refreshTreeNodeModel) {
        return this.treeBrowser.findSubHierarchy(NodeReference.fromNodeIds((Collection)refreshTreeNodeModel.getNodeIds()), new HashSet(refreshTreeNodeModel.getNodeList().getNodeReferences()));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{ids}/refresh"})
    public TreeGridResponse refreshNodes(@PathVariable List<String> ids, @RequestBody NodeList openedNodes) {
        return this.treeBrowser.findSubHierarchy(NodeReference.fromNodeIds(ids), new HashSet(openedNodes.getNodeReferences()));
    }

    @RequestMapping(value={"/deletion-simulation/{nodeIds}"}, method={RequestMethod.GET})
    public Messages simulateNodeDeletion(@PathVariable(value="nodeIds") List<Long> nodeIds, Locale locale) {
        List reportList = this.customReportLibraryNodeService.simulateDeletion(nodeIds);
        Messages messages = new Messages();
        for (SuppressionPreviewReport report : reportList) {
            messages.addMessage(report.toString(this.messageSource, locale));
        }
        return messages;
    }

    @RequestMapping(value={"/{nodeIds}"}, method={RequestMethod.DELETE})
    public OperationReport confirmNodeDeletion(@PathVariable(value="nodeIds") List<Long> nodeIds) {
        return this.customReportLibraryNodeService.delete(nodeIds);
    }

    /*
     * Exception decompiling
     */
    @RequestMapping(value={"new-folder"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public DataRow addNewFolder(@RequestBody CustomReportFolderFormModel folderModel) throws BindException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @RequestMapping(value={"/{destinationId}/content/paste"}, method={RequestMethod.POST})
    public void copyNodes(@RequestBody NodeListAndWhiteList nodeListAndWhiteList, @PathVariable(value="destinationId") String destinationId) {
        NodeReference nodeReference = NodeReference.fromNodeId((String)destinationId);
        List copiedNodeIds = nodeListAndWhiteList.getIds();
        ClipboardPayload clipboardPayload = nodeListAndWhiteList.asClipboardPayload();
        try {
            NodeType nodeType = nodeReference.getNodeType();
            if (Objects.requireNonNull(nodeType) != NodeType.CUSTOM_REPORT_FOLDER && nodeType != NodeType.CUSTOM_REPORT_LIBRARY) {
                throw new IllegalArgumentException("copy nodes : specified destination type doesn't exists : " + nodeReference.getNodeType());
            }
            this.customReportLibraryNodeService.copyNodes(copiedNodeIds, nodeReference.getId(), clipboardPayload);
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
    }

    @RequestMapping(value={"/{destinationRef}/content/move"}, method={RequestMethod.POST})
    public void moveNodes(@RequestBody NodeList nodeList, @PathVariable(value="destinationRef") String destinationRef) {
        NodeReference nodeReference = NodeReference.fromNodeId((String)destinationRef);
        Long destinationId = nodeReference.getId();
        NodeType destinationType = nodeReference.getNodeType();
        List movedNodeIds = nodeList.getIds();
        try {
            if (Objects.requireNonNull(destinationType) != NodeType.CUSTOM_REPORT_FOLDER && destinationType != NodeType.CUSTOM_REPORT_LIBRARY) {
                throw new IllegalArgumentException("move nodes : specified destination type doesn't exists : " + destinationType);
            }
            this.customReportLibraryNodeService.moveNodes(movedNodeIds, destinationId);
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
    }

    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(value={"new-dashboard"})
    public DataRow addNewDashBoard(@RequestBody DashboardFormModel dashboardFormModel) throws BindException {
        this.validateDashboardFormModel(dashboardFormModel);
        Long parentId = dashboardFormModel.getParentNodeReference().getId();
        CustomReportLibraryNode newNode = this.customReportLibraryNodeService.createNewNode(parentId, (CustomReportTreeEntity)dashboardFormModel.getDashboard());
        return this.treeNodeCollectorService.collectNode(NodeType.CUSTOM_REPORT_DASHBOARD, (Identified)newNode);
    }

    private void validateCustomReportFolderFormModel(CustomReportFolderFormModel folderModel) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)folderModel, ADD_CUSTOM_REPORT_FOLDER);
        EntityFormModelValidator entityFormModelValidator = new EntityFormModelValidator();
        entityFormModelValidator.validate((Object)folderModel, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
    }

    private void validateDashboardFormModel(DashboardFormModel dashboardFormModel) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)dashboardFormModel, ADD_DASHBOARD);
        EntityFormModelValidator entityFormModelValidator = new EntityFormModelValidator();
        entityFormModelValidator.validate((Object)dashboardFormModel, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$squashtest$tm$domain$EntityType() {
        if ($SWITCH_TABLE$org$squashtest$tm$domain$EntityType != null) {
            return $SWITCH_TABLE$org$squashtest$tm$domain$EntityType;
        }
        int[] nArray = new int[EntityType.values().length];
        try {
            nArray[EntityType.ACTION_TEST_STEP.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.ACTION_WORD.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.ACTION_WORD_LIBRARY.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.ATTACHMENT.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.ATTACHMENT_LIST.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.AUTOMATED_EXECUTION_EXTENDER.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.AUTOMATED_SUITE.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.AUTOMATED_TEST.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.AUTOMATION_REQUEST.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CAMPAIGN.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CAMPAIGN_FOLDER.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CAMPAIGN_LIBRARY.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CHART_DEFINITION.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CUSTOM_REPORT_CUSTOM_EXPORT.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CUSTOM_REPORT_DASHBOARD.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CUSTOM_REPORT_FOLDER.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.CUSTOM_REPORT_LIBRARY.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.DATASET.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.EXECUTION.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.EXECUTION_STEP.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.EXPLORATORY_SESSION_OVERVIEW.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.HIGH_LEVEL_REQUIREMENT.ordinal()] = 22;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.INFO_LIST_ITEM.ordinal()] = 23;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.ISSUE.ordinal()] = 24;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.ITEM_TEST_PLAN.ordinal()] = 25;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.ITERATION.ordinal()] = 26;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.MILESTONE.ordinal()] = 27;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.PARAMETER.ordinal()] = 28;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.PROJECT.ordinal()] = 29;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.REPORT_DEFINITION.ordinal()] = 30;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.REQUIREMENT.ordinal()] = 31;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.REQUIREMENT_FOLDER.ordinal()] = 32;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.REQUIREMENT_LIBRARY.ordinal()] = 33;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.REQUIREMENT_VERSION.ordinal()] = 34;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.SCM_REPOSITORY.ordinal()] = 35;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.SESSION_NOTE.ordinal()] = 36;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.SPRINT.ordinal()] = 37;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.SPRINT_GROUP.ordinal()] = 38;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.TEST_CASE.ordinal()] = 39;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.TEST_CASE_FOLDER.ordinal()] = 40;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.TEST_CASE_LIBRARY.ordinal()] = 41;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.TEST_CASE_STEP.ordinal()] = 42;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.TEST_STEP.ordinal()] = 43;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.TEST_SUITE.ordinal()] = 44;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EntityType.USER.ordinal()] = 45;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$squashtest$tm$domain$EntityType = nArray;
        return nArray;
    }
}

