/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.customreport;

import javax.validation.Valid;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.chart.ChartDefinition;
import org.squashtest.tm.domain.chart.ChartInstance;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.service.chart.ChartModificationService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.internal.display.dto.WorkbenchData;
import org.squashtest.tm.service.internal.dto.json.JsonChartInstance;
import org.squashtest.tm.web.backend.controller.form.model.CreatedEntityId;

@RestController
@RequestMapping(value={"/backend/chart-workbench"})
public class ChartWorkbenchController {
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    private final ChartModificationService chartService;

    public ChartWorkbenchController(CustomReportLibraryNodeService customReportLibraryNodeService, ChartModificationService chartService) {
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.chartService = chartService;
    }

    @GetMapping(value={"/{customReportLibraryNodeId}"})
    public WorkbenchData getWizardData(@PathVariable Long customReportLibraryNodeId) {
        return this.chartService.getWorkbenchData(customReportLibraryNodeId);
    }

    @RequestMapping(value={"/preview"}, method={RequestMethod.POST})
    public JsonChartInstance generate(@RequestBody @Valid ChartDefinition definition) {
        ChartInstance instance = this.chartService.generateChart(definition, null, null);
        return new JsonChartInstance(instance);
    }

    @RequestMapping(value={"/preview/{projectId}"}, method={RequestMethod.POST})
    public JsonChartInstance generateWithoutProject(@PathVariable(value="projectId") Long projectId, @RequestBody ChartDefinition definition) {
        ChartInstance instance = this.chartService.generateChart(definition, projectId);
        return new JsonChartInstance(instance);
    }

    @PostMapping(value={"/new/{id}"})
    public CreatedEntityId createNewChartDefinition(@RequestBody @Valid ChartDefinition definition, @PathVariable(value="id") long id) {
        CustomReportLibraryNode node = this.customReportLibraryNodeService.createNewNode(Long.valueOf(id), (CustomReportTreeEntity)definition);
        return new CreatedEntityId(node.getId());
    }

    @PostMapping(value={"/update/{id}"})
    public void updateChartDefinition(@RequestBody @Valid ChartDefinition definition, @PathVariable(value="id") long id) {
        this.chartService.updateDefinition(definition, Long.valueOf(id));
    }
}

