/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.customexport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityNotFoundException;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.customreport.CustomExportColumnLabel;
import org.squashtest.tm.domain.customreport.CustomReportCustomExport;
import org.squashtest.tm.domain.customreport.CustomReportCustomExportColumn;
import org.squashtest.tm.service.customfield.CustomFieldFinderService;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;
import org.squashtest.tm.service.customreport.CustomReportCustomExportCSVService;
import org.squashtest.tm.service.internal.repository.ExecutionStepDao;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

public class CustomExportCSVHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomExportCSVHelper.class);
    private static final char SEPARATOR = ';';
    private static final String CARRIAGE_RETURN = "\n";
    private static final String ESCAPED_QUOTE = "\"";
    private static final String NOT_AVAILABLE = "n/a;";
    private static final String SPACE_DASH_SPACE = " - ";
    private CustomReportCustomExportCSVService csvService;
    private CustomFieldFinderService cufService;
    private CustomFieldValueFinderService cufValueService;
    private InternationalizationHelper translator;
    private Locale locale;
    @Inject
    private ExecutionStepDao executionStepDao;

    public CustomExportCSVHelper(CustomReportCustomExportCSVService csvService, CustomFieldFinderService cufService, CustomFieldValueFinderService cufValueService, InternationalizationHelper translator, Locale locale, ExecutionStepDao executionStepDao) {
        this.csvService = csvService;
        this.cufService = cufService;
        this.cufValueService = cufValueService;
        this.translator = translator;
        this.locale = locale;
        this.executionStepDao = executionStepDao;
    }

    public String getInternationalizedHeaders(CustomReportCustomExport customExport) {
        StringBuilder builder = new StringBuilder();
        for (CustomReportCustomExportColumn column : customExport.getColumns()) {
            builder.append(ESCAPED_QUOTE).append(this.buildInternationalizedHeaderLabel(column)).append(ESCAPED_QUOTE).append(';');
        }
        builder.append(CARRIAGE_RETURN);
        return builder.toString();
    }

    private String buildInternationalizedHeaderLabel(CustomReportCustomExportColumn column) {
        CustomExportColumnLabel columnLabel = column.getLabel();
        String internationalizedHeaderName = this.getInternationalizedHeaderName(column);
        return String.valueOf(columnLabel.getShortenedEntityType()) + SPACE_DASH_SPACE + internationalizedHeaderName;
    }

    private String getInternationalizedHeaderName(CustomReportCustomExportColumn column) {
        if (column.getCufId() == null) {
            return this.translator.internationalize(column.getLabel().getI18nKey(), this.locale);
        }
        try {
            return this.cufService.findById(column.getCufId()).getLabel();
        }
        catch (EntityNotFoundException ex) {
            LOGGER.info("Custom Field of ID " + column.getCufId() + " was deleted and will be written as such.", (Throwable)ex);
            return this.translator.internationalize("squashtm.itemdeleted", this.locale);
        }
    }

    public String getWritableRowsData(CustomReportCustomExport customExport, boolean printLastExec) {
        Map entityTypeToCufIdsListMap = this.extractEntityTypeToCufIdsMap(customExport);
        Map rowsData = this.csvService.getRowsData(customExport, entityTypeToCufIdsListMap.keySet(), printLastExec);
        Map campaignProgressRate = this.csvService.computeCampaignProgressRate(rowsData.keySet());
        Map cufValuesMapByEntityReference = this.getEntityRefToCufValuesMapMap(customExport, entityTypeToCufIdsListMap);
        return this.buildResultString(rowsData, customExport.getColumns(), cufValuesMapByEntityReference, campaignProgressRate);
    }

    private Map<EntityType, List<Long>> extractEntityTypeToCufIdsMap(CustomReportCustomExport customExport) {
        return customExport.getColumns().stream().filter(column -> column.getCufId() != null).collect(Collectors.groupingBy(column -> column.getLabel().getEntityType(), Collectors.mapping(CustomReportCustomExportColumn::getCufId, Collectors.toList())));
    }

    private Map<EntityReference, Map<Long, Object>> getEntityRefToCufValuesMapMap(CustomReportCustomExport customExport, Map<EntityType, List<Long>> entityTypeToCufIdsListMap) {
        if (entityTypeToCufIdsListMap.isEmpty()) {
            return new HashMap<EntityReference, Map<Long, Object>>();
        }
        List entity = customExport.getScope();
        return this.cufValueService.getCufValueMapByEntityRef(entity, entityTypeToCufIdsListMap);
    }

    private String buildResultString(Map<Long, Result<Record>> resultSet, List<CustomReportCustomExportColumn> selectedColumns, Map<EntityReference, Map<Long, Object>> cufMap, Map<Long, Object> campaignProgressRate) {
        StringBuilder dataBuilder = new StringBuilder();
        resultSet.forEach((campaignId, records) -> records.forEach(record -> this.appendRowValues(selectedColumns, cufMap, campaignProgressRate, dataBuilder, campaignId, record)));
        return dataBuilder.toString();
    }

    private void appendRowValues(List<CustomReportCustomExportColumn> selectedColumns, Map<EntityReference, Map<Long, Object>> cufMap, Map<Long, Object> campaignProgressRate, StringBuilder dataBuilder, Long campaignId, Record record) {
        List rowValues = this.generateRowValues(record, selectedColumns, cufMap, campaignProgressRate.get(campaignId));
        for (Object value : rowValues) {
            if (value != null && !String.valueOf(value).isEmpty()) {
                dataBuilder.append(ESCAPED_QUOTE).append(value).append(ESCAPED_QUOTE).append(';');
                continue;
            }
            dataBuilder.append(NOT_AVAILABLE);
        }
        dataBuilder.append(CARRIAGE_RETURN);
    }

    private List<Object> generateRowValues(Record record, List<CustomReportCustomExportColumn> selectedColumns, Map<EntityReference, Map<Long, Object>> cufMap, Object campaignProgressRate) {
        ArrayList<Object> rowValues = new ArrayList<Object>();
        for (CustomReportCustomExportColumn column : selectedColumns) {
            Object value = this.computeOutputValue(record, column, cufMap, campaignProgressRate);
            rowValues.add(value);
        }
        return rowValues;
    }

    private Object computeOutputValue(Record record, CustomReportCustomExportColumn column, Map<EntityReference, Map<Long, Object>> cufMap, Object campaignSuccessRate) {
        CustomExportColumnLabel label = column.getLabel();
        Field columnField = label.getJooqTableField();
        Object value = label.equals((Object)CustomExportColumnLabel.TEST_CASE_NATURE) || label.equals((Object)CustomExportColumnLabel.TEST_CASE_TYPE) ? this.translateI18nKey(record, columnField) : (CustomExportColumnLabel.getRichTextFieldsSet().contains(label) ? this.computeRichValue(record.get(columnField)) : (label.equals((Object)CustomExportColumnLabel.CAMPAIGN_PROGRESS_STATUS) ? campaignSuccessRate : (columnField != null ? record.get(columnField) : this.computeOutputValueForCustomField(record, column, cufMap, label))));
        return this.replaceDoubleQuotesIsNeeded(label, value) ? this.replaceDoubleQuotes(value.toString()) : value;
    }

    private Object translateI18nKey(Record record, Field<?> columnField) {
        Object i18nKey = record.get(columnField);
        if (i18nKey != null) {
            String i18nKeyString = String.valueOf(i18nKey);
            return this.translator.getMessage(i18nKeyString, null, i18nKeyString, this.locale);
        }
        return null;
    }

    private Object computeOutputValueForCustomField(Record record, CustomReportCustomExportColumn column, Map<EntityReference, Map<Long, Object>> cufMap, CustomExportColumnLabel label) {
        EntityReference entityReference;
        Map<Long, Object> cufValuesMap;
        long cufId = column.getCufId();
        EntityType entityType = label.getEntityType();
        Long entityId = (Long)record.get((Field)CustomExportColumnLabel.getEntityTypeToIdTableFieldMap().get(entityType));
        if (entityId != null && (cufValuesMap = cufMap.get(entityReference = new EntityReference(entityType, entityId))) != null) {
            return this.computeRichValue(cufValuesMap.get(cufId));
        }
        return null;
    }

    private String computeRichValue(Object rawValue) {
        if (rawValue == null) {
            return null;
        }
        String cleanHtml = HTMLCleanupUtils.cleanHtml((String)String.valueOf(rawValue));
        String formattedHtml = this.adaptHtmlImageAttribute(cleanHtml);
        return HTMLCleanupUtils.htmlToTrimmedText((String)HTMLCleanupUtils.cleanHtml((String)formattedHtml));
    }

    private String adaptHtmlImageAttribute(String html) {
        Document document = Jsoup.parse((String)html);
        Elements elements = document.select("img");
        if (!elements.isEmpty()) {
            elements.forEach(element -> {
                String imageSrc = element.attr("src");
                if (!imageSrc.contains("data:image")) {
                    element.attr("alt", imageSrc);
                }
            });
            return document.body().html();
        }
        return html;
    }

    private String replaceDoubleQuotes(String text) {
        return text.replace(ESCAPED_QUOTE, "'");
    }

    private boolean replaceDoubleQuotesIsNeeded(CustomExportColumnLabel label, Object value) {
        return value != null && CustomExportColumnLabel.getCustomizableTextFieldsSet().contains(label);
    }
}

