/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.config;

import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.web.backend.controller.config.SquashFeatureController;

@RestController
@RequestMapping(value={"/backend/features"})
public class SquashFeatureController {
    private static final String ENABLED = "enabled";
    private final Object monitor = new Object();
    @Inject
    private FeatureManager featureManager;
    @Inject
    private ServletContext applicationScope;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/milestones"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Secured(value={"ROLE_ADMIN"})
    public void setMilestonesFeature(@RequestBody SetMilestoneFeatureRequestBody requestBody) {
        Boolean enabled = requestBody.getEnabled();
        Object object = this.monitor;
        synchronized (object) {
            Object prevState = this.applicationScope.getAttribute("milestoneFeatureEnabled");
            this.applicationScope.setAttribute("milestoneFeatureEnabled", (Object)false);
            try {
                this.featureManager.setEnabled(FeatureManager.Feature.MILESTONE, enabled.booleanValue());
                this.applicationScope.setAttribute("milestoneFeatureEnabled", (Object)enabled);
            }
            catch (RuntimeException ex) {
                this.applicationScope.setAttribute("milestoneFeatureEnabled", prevState);
                throw ex;
            }
        }
    }

    @RequestMapping(value={"/case-insensitive-login"}, method={RequestMethod.POST}, params={"enabled"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Secured(value={"ROLE_ADMIN"})
    public void setCaseInsensitiveLoginFeature(@RequestParam(value="enabled") boolean enabled) {
        this.featureManager.setEnabled(FeatureManager.Feature.CASE_INSENSITIVE_LOGIN, enabled);
    }

    @RequestMapping(value={"/case-insensitive-actions"}, method={RequestMethod.POST}, params={"enabled"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Secured(value={"ROLE_ADMIN"})
    public void setCaseInsensitiveActionsFeature(@RequestParam(value="enabled") boolean enabled) {
        this.featureManager.setEnabled(FeatureManager.Feature.CASE_INSENSITIVE_ACTIONS, enabled);
    }

    @RequestMapping(value={"/stack-trace"}, method={RequestMethod.POST}, params={"enabled"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Secured(value={"ROLE_ADMIN"})
    public void setStackTraceFeature(@RequestParam(value="enabled") boolean enabled) {
        this.featureManager.setEnabled(FeatureManager.Feature.STACK_TRACE, enabled);
    }

    @RequestMapping(value={"/unsafe-attachment-preview"}, method={RequestMethod.POST}, params={"enabled"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Secured(value={"ROLE_ADMIN"})
    public void setUnsafeAttachmentPreviewFeature(@RequestParam(value="enabled") boolean enabled) {
        this.featureManager.setEnabled(FeatureManager.Feature.UNSAFE_ATTACHMENT_PREVIEW, enabled);
    }

    @RequestMapping(value={"/autoconnect-on-connection"}, method={RequestMethod.POST}, params={"enabled"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Secured(value={"ROLE_ADMIN"})
    public void setAutoconnectOnConnectionFeature(@RequestParam(value="enabled") boolean enabled) {
        this.featureManager.setEnabled(FeatureManager.Feature.AUTOCONNECT_ON_CONNECTION, enabled);
    }

    @RequestMapping(value={"/search-activation"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Secured(value={"ROLE_ADMIN"})
    public void setSearchActivationFeature(@RequestBody SetMilestoneFeatureRequestBody requestBody) {
        Boolean enabled = requestBody.getEnabled();
        this.featureManager.setEnabled(FeatureManager.Feature.SEARCH_ACTIVATION, enabled.booleanValue());
    }
}

