/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.service.campaign.CreatedTestPlanItems;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.campaign.TestSuiteTestPlanManagerService;
import org.squashtest.tm.service.display.campaign.IterationDisplayService;
import org.squashtest.tm.service.display.campaign.IterationTestPlanDisplayService;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.IterationKnownIssueFinder;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.web.backend.controller.campaign.IterationTestPlanManagerController;
import org.squashtest.tm.web.backend.controller.campaign.TestCaseIdForm;

@RestController
@RequestMapping(value={"backend/iteration"})
public class IterationTestPlanManagerController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IterationTestPlanManagerController.class);
    private final IterationTestPlanManagerService iterationTestPlanManagerService;
    private final IterationModificationService iterationModificationService;
    private final IterationTestPlanDisplayService iterationTestPlanDisplayService;
    private final TestSuiteTestPlanManagerService testSuiteTestPlanManagerService;
    private final IterationDisplayService iterationDisplayService;
    private final IterationKnownIssueFinder iterationKnownIssueFinder;

    public IterationTestPlanManagerController(IterationTestPlanManagerService iterationTestPlanManagerService, IterationModificationService iterationModificationService, IterationTestPlanDisplayService iterationTestPlanDisplayService, TestSuiteTestPlanManagerService testSuiteTestPlanManagerService, IterationDisplayService iterationDisplayService, IterationKnownIssueFinder iterationKnownIssueFinder) {
        this.iterationTestPlanManagerService = iterationTestPlanManagerService;
        this.iterationModificationService = iterationModificationService;
        this.iterationTestPlanDisplayService = iterationTestPlanDisplayService;
        this.testSuiteTestPlanManagerService = testSuiteTestPlanManagerService;
        this.iterationDisplayService = iterationDisplayService;
        this.iterationKnownIssueFinder = iterationKnownIssueFinder;
    }

    @RequestMapping(value={"/{iterationId}/test-plan"}, method={RequestMethod.POST})
    public GridResponse findIterationTestPlan(@PathVariable Long iterationId, @RequestBody GridRequest gridRequest) {
        return this.iterationDisplayService.findTestPlan(iterationId, gridRequest);
    }

    @RequestMapping(value={"/{iterationId}/test-plan/{itemId}/executions"}, method={RequestMethod.POST})
    public GridResponse findIterationTestPlanExecutions(@PathVariable(value="iterationId") Long iterationId, @PathVariable(value="itemId") long itemId, @RequestBody GridRequest gridRequest) {
        return this.iterationTestPlanDisplayService.getITPIExecutions(iterationId, Long.valueOf(itemId), gridRequest);
    }

    @RequestMapping(value={"/{iterationId}/test-plan-items"}, method={RequestMethod.POST})
    public CreatedTestPlanItems addTestCasesToIteration(@RequestBody TestCaseIdForm testCaseIdForm, @PathVariable long iterationId) {
        return this.iterationTestPlanManagerService.addTestCasesToIteration(testCaseIdForm.getTestCaseIds(), iterationId);
    }

    @RequestMapping(value={"/{iterationId}/test-plan/{testPlanItemsIds}"}, method={RequestMethod.DELETE})
    public DeletedTestPlanItemReport removeTestPlanItemsFromIteration(@PathVariable(value="testPlanItemsIds") List<Long> testPlanItemsIds, @PathVariable long iterationId) {
        DeletedTestPlanItemReport report = new DeletedTestPlanItemReport();
        boolean hasTestPlanItemNotDeleted = this.iterationTestPlanManagerService.removeTestPlansFromIteration(testPlanItemsIds, iterationId);
        report.setHasTestPlanItemNotDeleted(hasTestPlanItemNotDeleted);
        report.setNbIssues((long)this.iterationKnownIssueFinder.countKnownIssues(Long.valueOf(iterationId)));
        return report;
    }

    @RequestMapping(value={"/{iterationId}/test-plan/execution/{executionIds}"}, method={RequestMethod.DELETE})
    public DeletedExecutionFromTestPlanItemReport removeExecutionsFromTestPlanItem(@PathVariable(value="executionIds") List<Long> executionIds, @PathVariable long iterationId) {
        this.iterationTestPlanManagerService.removeExecutionsFromTestPlanItem(executionIds, Long.valueOf(iterationId));
        DeletedExecutionFromTestPlanItemReport report = new DeletedExecutionFromTestPlanItemReport();
        report.setNbIssues((long)this.iterationKnownIssueFinder.countKnownIssues(Long.valueOf(iterationId)));
        return report;
    }

    @RequestMapping(value={"/{iterationId}/test-plan/{testPlanItemId}/executions/new-manual"}, method={RequestMethod.POST})
    public Map<String, Object> addManualExecution(@PathVariable long testPlanItemId, @PathVariable long iterationId) {
        LOGGER.trace("Add manual execution : creating execution");
        Execution newExecution = this.iterationModificationService.addManualExecution(testPlanItemId);
        LOGGER.trace("Add manual execution : completed in");
        HashMap<String, Object> responseBody = new HashMap<String, Object>();
        responseBody.put("executionId", newExecution.getId());
        return responseBody;
    }

    @RequestMapping(value={"/{iterationId}/test-plan/copy-items"}, method={RequestMethod.POST})
    public void addIterationTestPlanItemToIteration(@RequestBody IterationTestPlanItemPatch iterationTestPlanItemPatch, @PathVariable long iterationId) {
        this.iterationTestPlanManagerService.copyTestPlanItems(iterationTestPlanItemPatch.getItemTestPlanIds(), iterationId);
    }

    @PostMapping(value={"/test-plan/{itemIds}/mass-update"})
    public void massUpdate(@PathVariable(value="itemIds") List<Long> itemIds, @RequestBody ItpiMassEditPatch patch) {
        if (patch.getExecutionStatus() != null) {
            this.iterationTestPlanManagerService.forceExecutionStatus(itemIds, patch.getExecutionStatus());
        }
        if (patch.isChangeTestSuites()) {
            this.testSuiteTestPlanManagerService.unbindAllTestPlansFromTestPlanItem(itemIds);
            this.testSuiteTestPlanManagerService.bindTestPlanToMultipleSuites(patch.getTestSuites(), itemIds);
        }
        if (patch.isChangeAssignee()) {
            if (patch.getAssignee() == null) {
                this.iterationTestPlanManagerService.removeTestPlanItemsAssignments(itemIds);
            } else {
                this.iterationTestPlanManagerService.assignUserToTestPlanItems(itemIds, patch.getAssignee().longValue());
            }
        }
    }

    @RequestMapping(value={"/{iterationId}/test-plan/{itemIds}/position/{newIndex}"}, method={RequestMethod.POST})
    public void moveTestPlanItems(@PathVariable long iterationId, @PathVariable List<Long> itemIds, @PathVariable int newIndex) {
        this.iterationTestPlanManagerService.changeTestPlanPosition(iterationId, newIndex, itemIds);
    }
}

