/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.campaign.CampaignTestPlanManagerService;
import org.squashtest.tm.service.display.campaign.CampaignDisplayService;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.web.backend.controller.campaign.CampaignTestPlanManagerController;
import org.squashtest.tm.web.backend.controller.campaign.TestCaseIdForm;

@RestController
@RequestMapping(value={"backend/campaign"})
public class CampaignTestPlanManagerController {
    private final CampaignTestPlanManagerService campaignTestPlanManagerService;
    private final CampaignDisplayService campaignDisplayService;

    public CampaignTestPlanManagerController(CampaignTestPlanManagerService campaignTestPlanManagerService, CampaignDisplayService campaignDisplayService) {
        this.campaignTestPlanManagerService = campaignTestPlanManagerService;
        this.campaignDisplayService = campaignDisplayService;
    }

    @PostMapping(value={"/{campaignId}/test-plan"})
    public GridResponse findCampaignTestPlan(@PathVariable Long campaignId, @RequestBody GridRequest gridRequest) {
        return this.campaignDisplayService.findTestPlan(campaignId, gridRequest);
    }

    @PostMapping(value={"/{campaignId}/test-plan/{itemIds}/position/{newIndex}"})
    public void moveTestPlanItems(@PathVariable long campaignId, @PathVariable List<Long> itemIds, @PathVariable int newIndex) {
        this.campaignTestPlanManagerService.moveTestPlanItems(campaignId, newIndex, itemIds);
    }

    @RequestMapping(value={"/{campaignId}/test-plan-items"}, method={RequestMethod.POST})
    public Map<String, Object> addTestCasesToCampaign(@RequestBody TestCaseIdForm testCaseIdForm, @PathVariable long campaignId) {
        return this.campaignTestPlanManagerService.addTestCasesToCampaignTestPlan(testCaseIdForm.getTestCaseIds(), campaignId);
    }

    @DeleteMapping(value={"/{campaignId}/test-plan/{testPlanItemsIds}"})
    public void removeTestPlanItemsFromIteration(@PathVariable(value="testPlanItemsIds") List<Long> testPlanItemsIds, @PathVariable long campaignId) {
        this.campaignTestPlanManagerService.removeTestPlanItems(campaignId, testPlanItemsIds);
    }

    @PostMapping(value={"/test-plan/{itemIds}/mass-update"})
    public void massUpdate(@PathVariable(value="itemIds") List<Long> itemIds, @RequestBody CtpiMassEditPatch patch) {
        if (patch.isChangeAssignee()) {
            if (patch.getAssignee() == null) {
                this.campaignTestPlanManagerService.removeTestPlanItemsAssignments(itemIds);
            } else {
                this.campaignTestPlanManagerService.assignUserToTestPlanItems(itemIds, patch.getAssignee());
            }
        }
    }
}

