/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.actionword;

import javax.inject.Inject;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record5;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.actionword.ActionWordLibrary;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.LibraryDto;
import org.squashtest.tm.service.internal.display.dto.actionword.ActionWordLibraryDto;
import org.squashtest.tm.service.internal.repository.display.AttachmentDisplayDao;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Component
@Scope(value="prototype")
public class ActionWordLibraryDtoBuilder {
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private AttachmentDisplayDao attachmentDisplayDao;
    @Inject
    private DSLContext dslContext;

    public LibraryDto build(ActionWordLibrary actionWordLibrary) {
        LibraryDto actionWordLibraryDto = (LibraryDto)((Record5)this.dslContext.select((SelectField)Tables.ACTION_WORD_LIBRARY.AWL_ID.as("ID"), (SelectField)Tables.ACTION_WORD_LIBRARY.ATTACHMENT_LIST_ID, (SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.DESCRIPTION, (SelectField)Tables.PROJECT.NAME).from((TableLike)Tables.ACTION_WORD_LIBRARY).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.AWL_ID.eq((Field)Tables.ACTION_WORD_LIBRARY.AWL_ID)).where(Tables.ACTION_WORD_LIBRARY.AWL_ID.eq((Object)actionWordLibrary.getId())).fetchOne()).into(LibraryDto.class);
        actionWordLibraryDto.setAttachmentList(this.attachmentDisplayDao.findAttachmentListById(actionWordLibraryDto.getAttachmentListId().longValue()));
        return actionWordLibraryDto;
    }

    public void fillBasicAttributes(ActionWordLibrary actionWordLibrary, ActionWordLibraryDto actionWordLibraryDto) {
        actionWordLibraryDto.setName(actionWordLibrary.getProject().getName());
        actionWordLibraryDto.setDescription(HTMLCleanupUtils.htmlToText((String)actionWordLibrary.getProject().getDescription()));
    }

    public void fillAttachableAttributes(ActionWordLibrary actionWordLibrary, ActionWordLibraryDto actionWordLibraryDto) {
        actionWordLibraryDto.setAttachable(this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", "ATTACH", (Object)actionWordLibrary));
        actionWordLibraryDto.setAttachmentList(actionWordLibrary.getAttachmentList());
    }
}

