/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.squashtest.tm.service.user.UserAdministrationService;

@Controller
public class RootController {
    public static final String REDIRECT_AFTER_AUTH = "redirect-after-auth";
    public static final String INTERNAL_LOGIN_URL = "/login";
    private static final Logger LOGGER = LoggerFactory.getLogger(RootController.class);
    private final UserAdministrationService userAdministrationService;
    @Value(value="${squash.security.preferred-auth-url:/login}")
    private String preferredAuthUrl = "/login";

    public RootController(UserAdministrationService userAdministrationService) {
        this.userAdministrationService = userAdministrationService;
    }

    @GetMapping(value={"/"})
    public String mainEntryPoint(HttpServletRequest request, RedirectAttributes redirectAttributes, HttpSession httpSession) {
        boolean authenticated = this.isAuthenticated();
        if (authenticated) {
            String redirectUrl = this.restoreRedirectionUrl(request, httpSession);
            if (!this.userAdministrationService.findPostLoginInformation().isEmpty()) {
                redirectUrl = String.format("/information?%s=%s", REDIRECT_AFTER_AUTH, redirectUrl);
            }
            LOGGER.info("Received GET request on \"/\". User is authenticated, redirecting to " + redirectUrl);
            return "redirect:" + redirectUrl;
        }
        redirectAttributes.addAllAttributes(request.getParameterMap());
        httpSession.setAttribute(REDIRECT_AFTER_AUTH, request.getParameterMap().get(REDIRECT_AFTER_AUTH));
        LOGGER.info("Received GET request on \"/\". User is not authenticated, redirecting to " + this.preferredAuthUrl);
        return "redirect:" + this.preferredAuthUrl;
    }

    private String restoreRedirectionUrl(HttpServletRequest request, HttpSession httpSession) {
        Object redirectInSession;
        String redirectUrl = this.userAdministrationService.getDefaultAuthenticatedRedirectUrlForUserAuthority();
        String[] redirectInQueryParams = (String[])request.getParameterMap().get(REDIRECT_AFTER_AUTH);
        if ((redirectInQueryParams == null || redirectInQueryParams.length == 0) && (redirectInSession = httpSession.getAttribute(REDIRECT_AFTER_AUTH)) instanceof String[] && ((String[])redirectInSession).length > 0) {
            httpSession.removeAttribute(REDIRECT_AFTER_AUTH);
            redirectUrl = ((String[])redirectInSession)[0];
            LOGGER.info("Found a redirect-after-auth attribute is session. Redirect url is now set to " + redirectUrl);
        }
        return redirectUrl;
    }

    private boolean isAuthenticated() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        boolean isAnonymous = authentication instanceof AnonymousAuthenticationToken;
        return authentication != null && authentication.isAuthenticated() && !isAnonymous;
    }
}

