/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.config;

import javax.inject.Inject;
import javax.sql.DataSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerSecurityConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.client.JdbcClientDetailsService;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.code.JdbcAuthorizationCodeServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JdbcTokenStore;

@Configuration
public class OAuth2Config {
    private static final String OAUTH_SUBPATH = "/whatever";

    public static class AuthenticationServerConfig
    extends AuthorizationServerConfigurerAdapter {
        @Inject
        private DataSource dataSource;
        @Inject
        @Lazy
        private AuthenticationManager authenticationManager;

        public void configure(AuthorizationServerSecurityConfigurer security) throws Exception {
        }

        public void configure(AuthorizationServerEndpointsConfigurer endpoints) throws Exception {
            endpoints.authorizationCodeServices((AuthorizationCodeServices)this.authorizationCodeServices()).authenticationManager(this.authenticationManager).tokenStore(this.tokenStore());
        }

        public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
            clients.jdbc(this.dataSource);
        }

        @Bean
        public TokenStore tokenStore() {
            return new JdbcTokenStore(this.dataSource);
        }

        @Bean
        JdbcClientDetailsService clientDetailsService() {
            return new JdbcClientDetailsService(this.dataSource);
        }

        @Bean
        JdbcAuthorizationCodeServices authorizationCodeServices() {
            return new JdbcAuthorizationCodeServices(this.dataSource);
        }
    }

    @Configuration
    @EnableResourceServer
    public static class ResourceServerConfig
    extends ResourceServerConfigurerAdapter {
        @Inject
        TokenStore tokenStore;

        public void configure(ResourceServerSecurityConfigurer resources) throws Exception {
            resources.tokenStore(this.tokenStore);
        }

        public void configure(HttpSecurity http) throws Exception {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity.RequestMatcherConfigurer)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.NEVER).and()).requestMatchers().antMatchers(new String[]{"/whatever/**"})).and().authorizeRequests().antMatchers(HttpMethod.GET, new String[]{"/whatever/**"})).fullyAuthenticated();
        }
    }
}

