/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.config;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.squashtest.tm.api.security.authentication.ApiTokenPermissionsExemptionEndPoint;
import org.squashtest.tm.service.internal.security.SquashUserDetailsManager;
import org.squashtest.tm.service.jwt.JwtTokenService;
import org.squashtest.tm.service.user.UserManagerService;
import org.squashtest.tm.web.config.JwtConfig;

@Component
public class JwtTokenFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtTokenFilter.class);
    @Inject
    @Named(value="squashtest.core.security.JdbcUserDetailsManager")
    private SquashUserDetailsManager userManager;
    @Inject
    private JwtTokenService jwtTokenService;
    @Inject
    private JwtConfig jwtConfig;
    @Inject
    private UserManagerService userManagerService;
    @Autowired(required=false)
    private List<ApiTokenPermissionsExemptionEndPoint> tokenPermissionsExemptionEndPoints = Collections.emptyList();

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            String token = this.extractTokenFromRequest(request);
            List endPointExemptions = this.tokenPermissionsExemptionEndPoints.stream().map(ApiTokenPermissionsExemptionEndPoint::getIgnorePermissionsEndPoints).flatMap(Collection::stream).toList();
            if (token != null && this.jwtTokenService.validateApiToken(endPointExemptions, token, this.jwtConfig.getJwtSecret(), request)) {
                String userId = this.jwtTokenService.getUserIdFromToken(token, this.jwtConfig.getJwtSecret());
                String login = this.userManagerService.findLoginByUserId(Long.parseLong(userId));
                UserDetails userDetails = this.userManager.loadUserByUsername(login);
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            }
        }
        catch (BadCredentialsException e) {
            LOGGER.error("Invalid token", (Throwable)e);
            SecurityContextHolder.clearContext();
            response.sendError(401, e.getMessage());
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String extractTokenFromRequest(HttpServletRequest request) {
        String bearerToken = request.getHeader("Authorization");
        if (StringUtils.hasText((String)bearerToken) && bearerToken.startsWith("Bearer ")) {
            return bearerToken.substring(7);
        }
        return null;
    }
}

