/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.config;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class CustomRestApiBasicAuthFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomRestApiBasicAuthFilter.class);
    private static final String BASIC_AUTH_DISALLOWED = "Basic authentication is not allowed for REST API.";
    @Value(value="${squash.rest-api.disallow-basic-authentication:#{false}}")
    private boolean disallowBasicAuth;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.disallowBasicAuth && request.getHeader("Authorization") != null && request.getHeader("Authorization").startsWith("Basic ")) {
            LOGGER.error(BASIC_AUTH_DISALLOWED);
            SecurityContextHolder.clearContext();
            response.setStatus(401);
            response.setContentType("application/json");
            response.getWriter().write(BASIC_AUTH_DISALLOWED);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

