/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.report.criteria;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.squashtest.tm.api.report.Report;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.form.CheckboxesGroup;
import org.squashtest.tm.api.report.form.DropdownList;
import org.squashtest.tm.api.report.form.Input;
import org.squashtest.tm.api.report.form.InputType;
import org.squashtest.tm.api.report.form.InputsGroup;
import org.squashtest.tm.api.report.form.OptionInput;
import org.squashtest.tm.api.report.form.RadioButtonsGroup;
import org.squashtest.tm.api.report.form.TemplateDropdownList;
import org.squashtest.tm.web.backend.report.criteria.FormToCriteriaConverter;

public class ConciseFormToCriteriaConverter {
    private static final String CON_VAL = "val";
    private static final String CON_TYPE = "type";
    private static final String EXP_TYPE = "type";
    private static final String EXP_VALUE = "value";
    private static final String EXP_SEL = "selected";
    private static final String UNCHECKED = "unchecked";
    private static final String RAWTYPES = "rawtypes";
    private final FormToCriteriaConverter delegate = new FormToCriteriaConverter();
    private final Map<String, Input> flattenedInputByName = new HashMap<String, Input>();
    private final List<Long> projectIds;

    public ConciseFormToCriteriaConverter(@NotNull Report report, @NotNull List<Long> projectIds) {
        this.projectIds = projectIds;
        Collection<Input> flattenedInputs = this.flattenInputs(Arrays.asList(report.getForm()));
        for (Input input : flattenedInputs) {
            this.flattenedInputByName.put(input.getName(), input);
        }
    }

    public Map<String, Criteria> convert(Map<String, Object> conciseForm) {
        return this.delegate.convert(this.expand(conciseForm));
    }

    private Map<String, Object> expand(Map<String, Object> conciseForm) {
        Map<String, Object> expandedForm = this.expandedForm();
        this.populateExpandedForm(conciseForm, expandedForm);
        return expandedForm;
    }

    private void populateExpandedForm(Map<String, Object> conciseForm, Map<String, Object> expandedForm) {
        for (Map.Entry<String, Object> conciseInput : conciseForm.entrySet()) {
            this.populateExpandedInput(conciseInput.getKey(), conciseInput.getValue(), expandedForm);
        }
    }

    private void populateExpandedInput(String inputName, Object inputValue, Map<String, Object> expandedForm) {
        Map concise = (Map)inputValue;
        InputType type = InputType.valueOf((String)((String)concise.get("type")));
        List expanded = null;
        switch (type) {
            case TEXT: 
            case PASSWORD: 
            case DATE: {
                expanded = this.expendedSingleInput(concise);
                break;
            }
            case CHECKBOX: {
                expanded = this.expandedCheckbox(concise);
                break;
            }
            case RADIO_BUTTONS_GROUP: {
                expanded = this.expandedRadioButtonGroup(inputName, concise);
                break;
            }
            case DROPDOWN_LIST: {
                expanded = this.expandedDropdownList(inputName, concise);
                break;
            }
            case TEMPLATE_DROPDOWN_LIST: {
                expanded = this.expandedTemplateDropdownList(inputName, concise);
                break;
            }
            case CHECKBOXES_GROUP: {
                expanded = this.expandedCheckboxesGroup(inputName, concise);
                break;
            }
            case PROJECT_PICKER: {
                expanded = this.expandedProjectPicker(concise);
                break;
            }
            case TREE_PICKER: {
                Collection selNodes = (Collection)concise.get(CON_VAL);
                if (selNodes.isEmpty()) {
                    return;
                }
                expanded = this.expendedTreePicker(concise);
                break;
            }
            case MILESTONE_PICKER: 
            case TAG_PICKER: {
                expanded = this.expandedPickerList(concise);
            }
        }
        expandedForm.put(inputName, expanded);
    }

    private List<Object> expandedPickerList(Map concise) {
        Collection values = (Collection)concise.get(CON_VAL);
        ArrayList<Object> expandedModel = new ArrayList<Object>();
        HashMap mMap = new HashMap();
        mMap.put("type", concise.get("type"));
        mMap.put(EXP_VALUE, values);
        expandedModel.add(mMap);
        return expandedModel;
    }

    private List expendedTreePicker(Map concise) {
        Collection selNodes = (Collection)concise.get(CON_VAL);
        ArrayList exp = new ArrayList();
        for (Map node : selNodes) {
            HashMap expOpt = new HashMap();
            expOpt.put("type", concise.get("type"));
            expOpt.put(EXP_VALUE, node.get("resid"));
            expOpt.put("nodeType", node.get("restype"));
            exp.add(expOpt);
        }
        return exp;
    }

    private Map expendedSingleInput(Map concise) {
        HashMap exp = new HashMap();
        exp.put("type", concise.get("type"));
        exp.put(EXP_VALUE, concise.get(CON_VAL));
        return exp;
    }

    private Map expandedCheckbox(Map concise) {
        HashMap exp = new HashMap();
        exp.put("type", concise.get("type"));
        exp.put(EXP_SEL, concise.get(CON_VAL));
        exp.put(EXP_VALUE, "");
        return exp;
    }

    private List expandedProjectPicker(Map concise) {
        ArrayList exp = new ArrayList();
        Collection selVals = (Collection)concise.get(CON_VAL);
        for (Long projectId : this.projectIds) {
            HashMap expOpt = new HashMap();
            expOpt.put("type", concise.get("type"));
            expOpt.put(EXP_VALUE, String.valueOf(projectId));
            expOpt.put(EXP_SEL, selVals.contains(String.valueOf(projectId)));
            exp.add(expOpt);
        }
        return exp;
    }

    private List expandedRadioButtonGroup(String inputName, Map concise) {
        RadioButtonsGroup reportInput = (RadioButtonsGroup)this.flattenedInputByName.get(inputName);
        ArrayList exp = new ArrayList();
        Object selVal = concise.get(CON_VAL);
        for (OptionInput opt : reportInput.getOptions()) {
            this.filingExpandedGroups(concise, exp, opt, selVal);
        }
        return exp;
    }

    private void filingExpandedGroups(Map concise, List exp, OptionInput opt, Object selVal) {
        HashMap expOpt = new HashMap();
        expOpt.put("type", concise.get("type"));
        expOpt.put(EXP_VALUE, opt.getValue());
        expOpt.put(EXP_SEL, selVal.equals(opt.getValue()));
        exp.add(expOpt);
    }

    private List expandedDropdownList(String inputName, Map concise) {
        DropdownList reportInput = (DropdownList)this.flattenedInputByName.get(inputName);
        ArrayList exp = new ArrayList();
        Object selVal = concise.get(CON_VAL);
        for (OptionInput opt : reportInput.getOptions()) {
            this.filingExpandedGroups(concise, exp, opt, selVal);
        }
        return exp;
    }

    private List expandedTemplateDropdownList(String inputName, Map concise) {
        TemplateDropdownList reportInput = (TemplateDropdownList)this.flattenedInputByName.get(inputName);
        ArrayList exp = new ArrayList();
        Object selVal = concise.get(CON_VAL);
        for (OptionInput opt : reportInput.getOptions()) {
            this.filingExpandedGroups(concise, exp, opt, selVal);
        }
        return exp;
    }

    private List expandedCheckboxesGroup(String inputName, Map concise) {
        CheckboxesGroup reportInput = (CheckboxesGroup)this.flattenedInputByName.get(inputName);
        ArrayList exp = new ArrayList();
        Collection selVals = (Collection)concise.get(CON_VAL);
        for (OptionInput opt : reportInput.getOptions()) {
            HashMap expOpt = new HashMap();
            expOpt.put("type", concise.get("type"));
            expOpt.put(EXP_VALUE, opt.getValue());
            expOpt.put(EXP_SEL, selVals.contains(opt.getValue()));
            exp.add(expOpt);
        }
        return exp;
    }

    private Map<String, Object> expandedForm() {
        return new HashMap<String, Object>();
    }

    private Collection<Input> flattenInputs(List<Input> inputs) {
        ArrayList<Input> res = new ArrayList<Input>();
        for (Input input : inputs) {
            if (InputType.INPUTS_GROUP == input.getType()) {
                res.addAll(this.flattenInputs(((InputsGroup)input).getInputs()));
                continue;
            }
            res.add(input);
        }
        return res;
    }
}

