/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.model.builder;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.chart.ChartDefinition;
import org.squashtest.tm.domain.chart.ChartInstance;
import org.squashtest.tm.domain.customreport.CustomReportChartBinding;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.customreport.CustomReportReportBinding;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.query.ColumnRole;
import org.squashtest.tm.domain.query.SpecializedEntityType;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.service.chart.ChartModificationService;
import org.squashtest.tm.service.internal.display.dto.customreports.CustomReportDashboardDto;
import org.squashtest.tm.service.internal.dto.json.JsonChartInstance;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportChartBinding;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportDashboard;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportReportBinding;
import org.squashtest.tm.service.internal.dto.json.JsonReportInstance;
import org.squashtest.tm.service.internal.repository.display.HighLevelRequirementDisplayDao;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.web.backend.helper.ReportHelper;
import org.squashtest.tm.web.backend.report.IdentifiedReportDecorator;
import org.squashtest.tm.web.backend.report.ReportsRegistry;
import org.squashtest.tm.web.i18n.InternationalizationHelper;
import org.squashtest.tm.web.i18n.MessageObject;

@Component(value="customReport.dashboardBuilder")
@Scope(value="prototype")
public class JsonCustomReportDashboardBuilder {
    private ChartModificationService chartService;
    private JsonCustomReportDashboard json = new JsonCustomReportDashboard();
    private CustomReportDashboard dashboard;
    private InternationalizationHelper i18nHelper;
    private List<EntityReference> scope;
    private String i18nKeyDateFormat = "squashtm.dateformat";
    private boolean isMilestoneDashboard = false;
    private boolean isExtendedHighLvlReqScope = false;
    private boolean isLastExecutionScope = false;
    private Milestone milestone;
    private Workspace workspace;
    @Inject
    private ReportHelper reportHelper;
    @Inject
    private ReportsRegistry reportsRegistry;
    @Inject
    private HighLevelRequirementDisplayDao highLevelRequirementDisplayDao;

    @Inject
    public JsonCustomReportDashboardBuilder(ChartModificationService chartService, InternationalizationHelper i18nHelper, ActiveMilestoneHolder activeMilestoneHolder) {
        this.chartService = chartService;
        this.i18nHelper = i18nHelper;
        this.milestone = activeMilestoneHolder.getActiveMilestone().orElse(null);
    }

    public JsonCustomReportDashboard build(Long customReportLibraryNodeId, CustomReportDashboard dashboard, Locale locale) {
        return this.getJsonCustomReportDashboard(customReportLibraryNodeId, dashboard, locale);
    }

    public JsonCustomReportDashboard build(Long customReportLibraryNodeId, CustomReportDashboard dashboard, Locale locale, List<EntityReference> scope) {
        this.scope = scope;
        return this.getJsonCustomReportDashboard(customReportLibraryNodeId, dashboard, locale);
    }

    public JsonCustomReportDashboard build(Long customReportLibraryNodeId, CustomReportDashboard dashboard, Locale locale, CustomReportDashboardDto dto) {
        this.scope = dto.scope();
        this.isMilestoneDashboard = dto.isMilestoneDashboard();
        this.workspace = dto.workspace();
        this.isExtendedHighLvlReqScope = dto.isExtendedHighLvlReqScope();
        this.isLastExecutionScope = dto.isLastExecutionScope();
        return this.getJsonCustomReportDashboard(customReportLibraryNodeId, dashboard, locale);
    }

    private JsonCustomReportDashboard getJsonCustomReportDashboard(Long customReportLibraryNodeId, CustomReportDashboard dashboard, Locale locale) {
        this.dashboard = dashboard;
        this.json.setCustomReportLibraryNodeId(customReportLibraryNodeId);
        this.doBaseAttributes();
        this.doBindings();
        this.doDateAttributes(locale);
        return this.json;
    }

    private void doBindings() {
        Set bindings = this.dashboard.getChartBindings();
        for (CustomReportChartBinding binding : bindings) {
            JsonCustomReportChartBinding jsonBinding = new JsonCustomReportChartBinding();
            this.setChartJsonBindingProperties(binding, jsonBinding);
            this.json.getChartBindings().add(jsonBinding);
        }
        Set reportBindings = this.dashboard.getReportBindings();
        for (CustomReportReportBinding reportBinding : reportBindings) {
            ReportDefinition reportDefinition = reportBinding.getReport();
            IdentifiedReportDecorator report = this.reportsRegistry.findReport(reportDefinition.getPluginNamespace());
            JsonCustomReportReportBinding jsonBinding = new JsonCustomReportReportBinding();
            this.setReportJsonBindingProperties(report, reportBinding, jsonBinding, reportDefinition);
            this.json.getReportBindings().add(jsonBinding);
        }
    }

    private void setChartJsonBindingProperties(CustomReportChartBinding binding, JsonCustomReportChartBinding jsonBinding) {
        jsonBinding.setId(binding.getId());
        jsonBinding.setDashboardId(this.dashboard.getId());
        jsonBinding.setChartDefinitionId(binding.getChart().getId());
        jsonBinding.setRow(binding.getRow());
        jsonBinding.setCol(binding.getCol());
        jsonBinding.setSizeX(binding.getSizeX());
        jsonBinding.setSizeY(binding.getSizeY());
        if (this.isExtendedHighLvlReqScope) {
            this.scope = this.retrieveExtendedHighLvlReqScope();
        }
        boolean canApplyLastExecutionScope = this.canApplyLastExecutionScope(binding.getChart().getInvolvedEntities());
        ChartInstance chartInstance = this.generateChartInstance(binding.getChart(), canApplyLastExecutionScope);
        jsonBinding.setChartInstance(new JsonChartInstance(chartInstance));
    }

    private void setReportJsonBindingProperties(IdentifiedReportDecorator report, CustomReportReportBinding reportBinding, JsonCustomReportReportBinding jsonBinding, ReportDefinition reportDefinition) {
        jsonBinding.setId(reportBinding.getId());
        jsonBinding.setDashboardId(this.dashboard.getId());
        jsonBinding.setReportDefinitionId(reportDefinition.getId());
        jsonBinding.setRow(reportBinding.getRow());
        jsonBinding.setCol(reportBinding.getCol());
        jsonBinding.setSizeX(reportBinding.getSizeX());
        jsonBinding.setSizeY(reportBinding.getSizeY());
        JsonReportInstance jsonReportInstance = new JsonReportInstance(reportDefinition);
        if (Objects.nonNull(report)) {
            jsonReportInstance.setLabel(report.getLabel());
            jsonReportInstance.setReportAttributes(this.reportHelper.getAttributesFromReportDefinition(reportDefinition));
            jsonReportInstance.setDocx(Boolean.valueOf(report.isDocxTemplate()));
            jsonReportInstance.setDirectDownloadableReport(Boolean.valueOf(report.isDirectDownloadableReport()));
            if (!report.isDirectDownloadableReport()) {
                jsonReportInstance.setPdfViews(report.getViews().length);
            }
            jsonBinding.setReportInstance(jsonReportInstance);
        } else {
            jsonReportInstance.setMissingPlugin(true);
            jsonReportInstance.setLabel(reportDefinition.getPluginNamespace());
        }
    }

    private ChartInstance generateChartInstance(ChartDefinition chart, boolean canApplyLastExecutionScope) {
        if (this.isMilestoneDashboard) {
            return this.chartService.generateChartForMilestoneDashboard(chart, this.milestone.getId(), this.workspace, this.isLastExecutionScope);
        }
        if (this.milestone != null) {
            return this.chartService.generateChartInMilestoneMode(chart, this.scope, this.workspace, this.isLastExecutionScope);
        }
        if (this.isLastExecutionScope && canApplyLastExecutionScope) {
            return this.chartService.generateChart(chart, this.scope, this.dashboard.getId(), this.isLastExecutionScope);
        }
        return this.chartService.generateChart(chart, this.scope, this.dashboard.getId());
    }

    private void doBaseAttributes() {
        this.json.setId(this.dashboard.getId());
        this.json.setProjectId(this.dashboard.getProject().getId());
        this.json.setName(this.dashboard.getName());
        CustomReportDashboard audit = this.dashboard;
        this.json.setCreatedBy(audit.getCreatedBy());
        this.json.setLastModifiedBy(audit.getLastModifiedBy());
    }

    private void doDateAttributes(Locale locale) {
        CustomReportDashboard audit = this.dashboard;
        String dateFormat = this.findI18nDateFormat(locale);
        SimpleDateFormat formater = new SimpleDateFormat(dateFormat);
        this.json.setCreatedOn(formater.format(audit.getCreatedOn()));
        if (audit.getLastModifiedBy() != null) {
            this.json.setLastModifiedOn(formater.format(audit.getLastModifiedOn()));
        } else {
            this.json.setLastModifiedOn("");
        }
    }

    private String findI18nDateFormat(Locale locale) {
        MessageObject message = new MessageObject();
        message.put(this.i18nKeyDateFormat, this.i18nKeyDateFormat);
        this.i18nHelper.resolve(message, locale);
        return (String)message.get(this.i18nKeyDateFormat);
    }

    private List<EntityReference> retrieveExtendedHighLvlReqScope() {
        ArrayList<EntityReference> references = new ArrayList<EntityReference>();
        ArrayList libIds = new ArrayList();
        ArrayList nodeIds = new ArrayList();
        this.scope.forEach(sc -> {
            switch (sc.getType()) {
                case REQUIREMENT_LIBRARY: {
                    libIds.add(sc.getId());
                    break;
                }
                case HIGH_LEVEL_REQUIREMENT: 
                case REQUIREMENT: 
                case REQUIREMENT_FOLDER: {
                    nodeIds.add(sc.getId());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong EntityType ! Available ones are REQUIREMENT_LIBRARY, REQUIREMENT_FOLDER HIGH_LEVEL_REQUIREMENT and REQUIREMENT.");
                }
            }
        });
        ArrayList reqIdsWithExtendedHighLvlReqScope = new ArrayList(this.highLevelRequirementDisplayDao.findRequirementIdsByLibraryIds(libIds, true));
        reqIdsWithExtendedHighLvlReqScope.addAll(this.highLevelRequirementDisplayDao.findRequirementIdsByNodeIds(nodeIds, true));
        if (!reqIdsWithExtendedHighLvlReqScope.isEmpty()) {
            reqIdsWithExtendedHighLvlReqScope.forEach(reqId -> {
                boolean bl = references.add(new EntityReference(EntityType.REQUIREMENT, reqId));
            });
            return references;
        }
        return this.scope;
    }

    private boolean canApplyLastExecutionScope(Map<ColumnRole, Set<SpecializedEntityType>> involvedEntities) {
        HashSet uniqueEntities = new HashSet();
        involvedEntities.forEach((key, value) -> {
            boolean bl = uniqueEntities.addAll(value);
        });
        return uniqueEntities.stream().anyMatch(entity -> EntityType.ITEM_TEST_PLAN.equals((Object)entity.getEntityType()));
    }
}

