/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.user;

import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.user.ApiTokenService;
import org.squashtest.tm.web.config.JwtConfig;

@RestController
@RequestMapping(value={"backend/api-token"})
public class ApiTokenController {
    private final JwtConfig jwtConfig;
    private final ApiTokenService apiTokenService;

    public ApiTokenController(JwtConfig jwtConfig, ApiTokenService apiTokenService) {
        this.jwtConfig = jwtConfig;
        this.apiTokenService = apiTokenService;
    }

    @PostMapping(value={"generate-api-token"})
    public Map<String, String> generateApiToken(@RequestBody ApiTokenModel apiTokenModel) {
        String jwt = this.apiTokenService.generateApiToken(this.jwtConfig.getJwtSecret(), apiTokenModel.name, apiTokenModel.expiryDate, apiTokenModel.permissions);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("token", Base64.getEncoder().encodeToString(jwt.getBytes()));
        return response;
    }

    @DeleteMapping(value={"{tokenId}"})
    public void deleteApiToken(@PathVariable long tokenId) {
        this.apiTokenService.deleteApiToken(tokenId);
    }

    public record ApiTokenModel(String name, Date expiryDate, String permissions) {
    }
}

