/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testcase.keyword;

import com.google.common.collect.Lists;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.service.actionword.ActionWordService;
import org.squashtest.tm.service.testcase.bdd.KeywordTestCaseService;
import org.squashtest.tm.web.backend.controller.form.model.ActionList;
import org.squashtest.tm.web.backend.controller.form.model.ScriptPreviewModel;
import org.squashtest.tm.web.backend.controller.testcase.keyword.ActionWordAutocompleteInput;

@Controller
@RequestMapping(value={"backend/keyword-test-cases"})
public class KeywordTestCaseController {
    @Autowired(required=false)
    private ActionWordService actionWordService;
    @Inject
    private KeywordTestCaseService keywordTestCaseService;

    @ResponseBody
    @PostMapping(value={"/autocomplete"})
    public ActionList findAllMatchingActionWords(@RequestBody ActionWordAutocompleteInput input) {
        return new ActionList(Lists.newArrayList((Iterable)this.actionWordService.findAllMatchingActionWords(input.getProjectId().longValue(), input.getSearchInput(), input.getSelectedProjectsIds())));
    }

    @ResponseBody
    @PostMapping(value={"/duplicated-action"})
    public Map<String, Long> findAllDuplicatedActionWithProject(@RequestBody ActionWordAutocompleteInput input) {
        return this.actionWordService.findAllDuplicatedActionWithProject(input.getProjectId().longValue(), input.getSearchInput());
    }

    @ResponseBody
    @RequestMapping(value={"/{testCaseId}/generated-script"})
    public ScriptPreviewModel getGeneratedScript(@PathVariable long testCaseId) {
        return new ScriptPreviewModel(this.keywordTestCaseService.writeScriptFromTestCase(testCaseId, false));
    }
}

