/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.requirement;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Provider;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.NodeReferences;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.display.requirements.RequirementDisplayService;
import org.squashtest.tm.service.internal.display.dto.customreports.CustomReportDashboardDto;
import org.squashtest.tm.service.internal.display.dto.requirement.RequirementMultiSelectionDto;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportDashboard;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.web.backend.controller.requirement.RequirementStatisticsController;
import org.squashtest.tm.web.backend.model.builder.JsonCustomReportDashboardBuilder;

@RestController
@RequestMapping(value={"/backend/requirement-workspace-multi-view"})
public class RequirementMultiViewController {
    private final RequirementLibraryNavigationService requirementLibraryNavigationService;
    private final RequirementDisplayService requirementDisplayService;
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    @Named(value="customReport.dashboardBuilder")
    private final Provider<JsonCustomReportDashboardBuilder> builderProvider;

    public RequirementMultiViewController(RequirementDisplayService requirementDisplayService, RequirementLibraryNavigationService requirementLibraryNavigationService, CustomReportLibraryNodeService customReportLibraryNodeService, Provider<JsonCustomReportDashboardBuilder> builderProvider) {
        this.requirementDisplayService = requirementDisplayService;
        this.requirementLibraryNavigationService = requirementLibraryNavigationService;
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.builderProvider = builderProvider;
    }

    @ResponseBody
    @PostMapping
    public RequirementMultiSelectionDto getRequirementMultiView(@RequestBody RequirementStatisticsController.RequirementNodeList statisticRequest, Locale locale) {
        NodeReferences nodeReferences = statisticRequest.asNodeReferences();
        RequirementMultiSelectionDto requirementMultiView = this.requirementDisplayService.getRequirementMultiView();
        if (requirementMultiView.isShouldShowFavoriteDashboard()) {
            if (requirementMultiView.isCanShowFavoriteDashboard()) {
                List<String> references = statisticRequest.getReferences();
                List entityReferences = references.stream().map(EntityReference::fromNodeId).collect(Collectors.toList());
                CustomReportDashboard dashboard = this.customReportLibraryNodeService.findCustomReportDashboardById(requirementMultiView.getFavoriteDashboardId());
                CustomReportDashboardDto dashboardDto = new CustomReportDashboardDto(Workspace.REQUIREMENT, entityReferences, false, statisticRequest.isExtendedHighLvlReqScope(), false);
                JsonCustomReportDashboard jsonDashboard = ((JsonCustomReportDashboardBuilder)this.builderProvider.get()).build(requirementMultiView.getFavoriteDashboardId(), dashboard, locale, dashboardDto);
                requirementMultiView.setDashboard(jsonDashboard);
            }
        } else {
            Set libraryIds = nodeReferences.extractLibraryIds();
            Set requirementNodeIds = nodeReferences.extractNonLibraryIds();
            requirementMultiView.setStatistics(this.requirementLibraryNavigationService.getStatisticsForSelection((Collection)libraryIds, (Collection)requirementNodeIds, statisticRequest.isExtendedHighLvlReqScope()));
        }
        return requirementMultiView;
    }
}

