/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.report;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.jooq.tools.json.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.api.report.BasicDirectDownloadableReport;
import org.squashtest.tm.api.report.DocxTemplaterReport;
import org.squashtest.tm.api.report.Report;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.spring.view.docxtemplater.DocxTemplaterDocxView;
import org.squashtest.tm.api.utils.CurrentUserHelper;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.report.ReportFinderService;
import org.squashtest.tm.service.report.ReportTemplateManagerService;
import org.squashtest.tm.web.backend.helper.JsonHelper;
import org.squashtest.tm.web.backend.report.IdentifiedReportDecorator;
import org.squashtest.tm.web.backend.report.ReportsRegistry;
import org.squashtest.tm.web.backend.report.criteria.ConciseFormToCriteriaConverter;

@Controller
@RequestMapping(value={"backend/reports/{namespace}"})
public class ReportGenerationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportGenerationController.class);
    private static final String ATTACHMENT_FILENAME = "attachment; filename=";
    private final ReportsRegistry reportsRegistry;
    private final ProjectFinder projectFinder;
    private final ReportFinderService reportFinderService;
    private final UltimateLicenseAvailabilityService ultimateLicenseService;
    private final ReportTemplateManagerService reportTemplateManagerService;
    private final CurrentUserHelper currentUserHelper;

    public ReportGenerationController(ReportsRegistry reportsRegistry, ProjectFinder projectFinder, ReportFinderService reportFinderService, UltimateLicenseAvailabilityService licenseService, ReportTemplateManagerService reportTemplateManagerService, CurrentUserHelper currentUserHelper) {
        this.reportsRegistry = reportsRegistry;
        this.projectFinder = projectFinder;
        this.reportFinderService = reportFinderService;
        this.ultimateLicenseService = licenseService;
        this.reportTemplateManagerService = reportTemplateManagerService;
        this.currentUserHelper = currentUserHelper;
    }

    @RequestMapping(value={"/views/{viewIndex}/formats/{format}"}, method={RequestMethod.GET}, params={"json"})
    public ModelAndView getReportView(@PathVariable String namespace, @PathVariable int viewIndex, @PathVariable String format, @RequestParam(value="json") String parameters) throws IOException {
        IdentifiedReportDecorator report = this.reportsRegistry.findReport(namespace);
        Map<String, Criteria> crit = this.retrieveReportFormCriteriaMap(parameters, report);
        return report.buildModelAndView(viewIndex, format, crit);
    }

    @RequestMapping(value={"/views/{viewIndex}/data/docx"}, method={RequestMethod.GET}, params={"json"})
    @ResponseBody
    public Map<String, Object> getReportView(@PathVariable String namespace, @PathVariable int viewIndex, @RequestParam(value="json") String parameters) throws IOException {
        IdentifiedReportDecorator report = this.reportsRegistry.findReport(namespace);
        Map<String, Criteria> crit = this.retrieveReportFormCriteriaMap(parameters, report);
        return report.buildModelAndView(viewIndex, "docx", crit).getModel();
    }

    @RequestMapping(value={"/data/direct-downloadable-report"}, method={RequestMethod.GET}, params={"json"})
    @ResponseBody
    public ResponseEntity<InputStreamResource> getDownloadableReport(@PathVariable String namespace, @RequestParam(value="json") String parameters) throws IOException {
        IdentifiedReportDecorator reportDecorator = this.reportsRegistry.findReport(namespace);
        Map<String, Criteria> crit = this.retrieveReportFormCriteriaMap(parameters, reportDecorator);
        if (reportDecorator.isDirectDownloadableReport()) {
            try {
                BasicDirectDownloadableReport directDownloadableReport = (BasicDirectDownloadableReport)reportDecorator.getReport();
                File report = directDownloadableReport.generateReport(crit);
                InputStreamResource resource = new InputStreamResource((InputStream)new FileInputStream(report));
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{ATTACHMENT_FILENAME + report.getName()})).contentType(MediaType.APPLICATION_OCTET_STREAM).contentLength(report.length()).body((Object)resource);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        throw new IllegalArgumentException();
    }

    @PostMapping(value={"/views/{viewIndex}/docxtemplate"})
    public void getTemplate(@PathVariable String namespace, @PathVariable int viewIndex, @RequestBody DocxTemplatePatch patch, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentifiedReportDecorator identifiedReportDecorator = this.reportsRegistry.findReport(namespace);
        Map<String, Object> templateModel = this.buildTemplateModel(patch, (DocxTemplaterReport)identifiedReportDecorator.getReport());
        identifiedReportDecorator.getViews()[viewIndex].getSpringView().render(templateModel, request, response);
    }

    @PostMapping(value={"/template-exists-in-folder"})
    @ResponseBody
    public boolean isTemplateFileExistInFolder(@PathVariable String namespace, @RequestBody DocxTemplatePatch patch) {
        DocxTemplaterReport docxReport = this.findDocXTemplaterReportByNamespace(namespace);
        String filePath = docxReport.getCustomTemplateFolderPath().concat(patch.getTemplateFileName());
        return this.reportTemplateManagerService.doesTemplateExistOnServer(filePath);
    }

    @PostMapping(value={"/add-report-template-file"})
    @ResponseBody
    public boolean addReportTemplateFile(@PathVariable String namespace, @RequestParam(value="archive") MultipartFile uploadedFile) {
        DocxTemplaterReport docxReport = this.findDocXTemplaterReportByNamespace(namespace);
        String filePath = docxReport.getCustomTemplateFolderPath().concat(Objects.requireNonNull(uploadedFile.getOriginalFilename()));
        return this.reportTemplateManagerService.addATemplateToServer(filePath, docxReport.getCustomTemplateFolderPath(), uploadedFile);
    }

    @GetMapping(value={"/download-default-template"})
    @ResponseBody
    public ResponseEntity<InputStreamResource> downloadDefaultTemplate(@PathVariable String namespace) throws IOException {
        DocxTemplaterReport docxReport = this.findDocXTemplaterReportByNamespace(namespace);
        Resource resource = ((DocxTemplaterDocxView)docxReport.getViews()[0].getSpringView()).downloadDefaultTemplate(docxReport.getDefaultTemplateFilePath());
        InputStreamResource res = new InputStreamResource(resource.getInputStream());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{ATTACHMENT_FILENAME + resource.getFilename()})).contentType(MediaType.APPLICATION_OCTET_STREAM).contentLength(resource.contentLength()).body((Object)res);
    }

    @GetMapping(value={"/download-custom-template/{templateFileName}"})
    @ResponseBody
    public void downloadCustomTemplate(@PathVariable String namespace, @PathVariable String templateFileName, HttpServletResponse response) {
        DocxTemplaterReport docxReport = this.findDocXTemplaterReportByNamespace(namespace);
        String filePath = docxReport.getCustomTemplateFolderPath().concat(templateFileName);
        File tempFile = new File(filePath);
        try {
            FileInputStream inputStream = new FileInputStream(tempFile);
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", ATTACHMENT_FILENAME + templateFileName);
            IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
            response.flushBuffer();
            ((InputStream)inputStream).close();
        }
        catch (IOException var7) {
            LOGGER.debug("file doesn't exist" + templateFileName, (Throwable)var7);
        }
    }

    @PostMapping(value={"/delete-custom-template"})
    @ResponseBody
    public void deleteCustomTemplate(@PathVariable String namespace, @RequestBody DocxTemplatePatch patch) {
        DocxTemplaterReport docxReport = this.findDocXTemplaterReportByNamespace(namespace);
        String filePath = docxReport.getCustomTemplateFolderPath().concat(patch.getTemplateFileName());
        this.reportTemplateManagerService.deleteTemplateFromServer(filePath);
    }

    @PostMapping(value={"/is-template-used-in-report"})
    @ResponseBody
    public boolean isTemplateUsedInReport(@PathVariable String namespace, @RequestBody DocxTemplatePatch patch) {
        return this.reportFinderService.isTemplateUsedInReport(patch.getTemplateFileName(), namespace);
    }

    private Map<String, Object> buildTemplateModel(DocxTemplatePatch patch, DocxTemplaterReport report) throws ParseException {
        HashMap<String, Object> templateModel = new HashMap<String, Object>();
        String templateFileName = this.retrieveTemplateFileName(patch);
        templateModel.put("customTemplateFolderPath", report.getCustomTemplateFolderPath());
        templateModel.put("defaultTemplateFilePath", report.getDefaultTemplateFilePath());
        templateModel.put("templateFileName", templateFileName);
        return templateModel;
    }

    private Map<String, Criteria> retrieveReportFormCriteriaMap(String parameters, Report report) throws IOException {
        Map<String, Object> form = JsonHelper.deserialize(parameters);
        List readableProjectIds = this.currentUserHelper.findFilteredReadableProjectIds();
        List projectIds = this.projectFinder.findAllProjectIdsOrderedByName(readableProjectIds);
        return new ConciseFormToCriteriaConverter(report, projectIds).convert(form);
    }

    private String retrieveTemplateFileName(DocxTemplatePatch patch) throws ParseException {
        String templateFileNameFromModel = patch.getTemplateFileName();
        if (!this.ultimateLicenseService.isAvailable()) {
            return "";
        }
        if (Objects.isNull(patch.getReportDefinitionId())) {
            return templateFileNameFromModel;
        }
        return StringUtils.hasText((String)templateFileNameFromModel) ? templateFileNameFromModel : this.reportFinderService.fetchTemplateFromParametersByReportDefinitionId(patch.getReportDefinitionId());
    }

    private DocxTemplaterReport findDocXTemplaterReportByNamespace(String namespace) {
        IdentifiedReportDecorator identifiedReportDecorator = this.reportsRegistry.findReport(namespace);
        return (DocxTemplaterReport)identifiedReportDecorator.getReport();
    }

    static class DocxTemplatePatch {
        private Long reportDefinitionId;
        private String templateFileName;

        DocxTemplatePatch() {
        }

        public Long getReportDefinitionId() {
            return this.reportDefinitionId;
        }

        public void setReportDefinitionId(Long reportDefinitionId) {
            this.reportDefinitionId = reportDefinitionId;
        }

        public String getTemplateFileName() {
            return this.templateFileName;
        }

        public void setTemplateFileName(String templateFileName) {
            this.templateFileName = templateFileName;
        }
    }
}

