/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.importer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.service.importer.EntityType;
import org.squashtest.tm.service.importer.ImportLog;
import org.squashtest.tm.service.importer.ImportStatus;
import org.squashtest.tm.service.importer.LogEntry;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Component
public abstract class ImportLogHelper {
    public static final String XLS_SUFFIX = ".xls";
    public static final List<String> headers = Arrays.asList("LINE", "TYPE", "ERROR", "IMPACT");
    @Inject
    protected InternationalizationHelper messageSource;
    private File tempDir;

    private void writeToTab(Collection<LogEntry> entries, Workbook workbook, String sheetName, Locale locale) {
        Sheet sheet = workbook.createSheet(sheetName);
        this.writeHeaderToTab(sheet);
        this.writeEntriesToTab(entries, sheet, locale);
    }

    private void writeHeaderToTab(Sheet sheet) {
        Row row = sheet.createRow(0);
        int cellnum = 0;
        for (String header : headers) {
            this.writeValueToCell(row.createCell(cellnum++), header);
        }
    }

    private void writeValueToCell(Cell cell, String value) {
        cell.setCellValue(value);
    }

    private void writeValueToCell(Cell cell, Number value) {
        cell.setCellValue(value.doubleValue());
    }

    private void writeEntriesToTab(Collection<LogEntry> entries, Sheet sheet, Locale locale) {
        if (entries.isEmpty()) {
            this.writeEntriesForEmptyLog(sheet, locale);
        } else {
            this.writeEntriesForLog(entries, sheet, locale);
        }
    }

    private void writeEntriesForLog(Collection<LogEntry> entries, Sheet sheet, Locale locale) {
        int rownum = 1;
        for (LogEntry entry : entries) {
            Row row = sheet.createRow(rownum++);
            int cellnum = 0;
            Cell cell = row.createCell(cellnum++);
            this.writeValueToCell(cell, entry.getLine());
            cell = row.createCell(cellnum++);
            this.writeValueToCell(cell, entry.getStatus().shortName());
            cell = row.createCell(cellnum++);
            if (entry.getI18nError() != null) {
                this.writeValueToCell(cell, this.messageSource.getMessage(entry.getI18nError(), entry.getErrorArgs(), locale));
            }
            cell = row.createCell(cellnum++);
            if (entry.getI18nImpact() == null) continue;
            this.writeValueToCell(cell, this.messageSource.getMessage(entry.getI18nImpact(), entry.getImpactArgs(), locale));
        }
    }

    private void writeEntriesForEmptyLog(Sheet sheet, Locale locale) {
        Row row = sheet.createRow(1);
        int cellnum = 0;
        Cell cell = row.createCell(cellnum++);
        this.writeValueToCell(cell, 0);
        cell = row.createCell(cellnum++);
        this.writeValueToCell(cell, ImportStatus.FAILURE.toString());
        cell = row.createCell(cellnum++);
        this.writeValueToCell(cell, this.messageSource.internationalize("message.import.log.error.empty", locale));
    }

    protected void writeToFile(ImportLog importLog, File emptyFile) throws IOException {
        Workbook workbook = this.buildWorkbook(importLog);
        this.writeToFile(emptyFile, workbook);
    }

    protected void writeToFile(File emptyFile, Workbook workbook) throws IOException {
        FileOutputStream os = null;
        try {
            try {
                os = new FileOutputStream(emptyFile);
                workbook.write((OutputStream)os);
                os.flush();
            }
            catch (IOException e) {
                this.getLogger().warn(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)os);
    }

    private Workbook buildWorkbook(ImportLog importLog) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        Locale locale = LocaleContextHolder.getLocale();
        Map<String, EntityType> entityTypeByTab = this.getEntityTypeByTab();
        for (Map.Entry<String, EntityType> entry : entityTypeByTab.entrySet()) {
            Collection logEntries = importLog.findAllFor(entry.getValue());
            this.writeToTab(logEntries, (Workbook)workbook, entry.getKey(), locale);
            this.getLogger().debug(String.valueOf(this.getImportLogPrefix()) + logEntries);
        }
        return workbook;
    }

    public String logFilename(@NotNull String logTimeStamp) {
        return String.valueOf(this.getImportLogPrefix()) + logTimeStamp;
    }

    public File fetchLogFile(String filename) {
        return new File(this.getTempDir(), filename);
    }

    private File getTempDir() {
        if (this.tempDir == null) {
            try {
                this.tempDir = File.createTempFile("temp", null).getParentFile();
            }
            catch (IOException e) {
                this.getLogger().error("Impossible to create a temp file ! Check fs permissions", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.tempDir;
    }

    public File storeLogFile(ImportLog summary) throws IOException {
        File logFile = File.createTempFile(this.getImportLogPrefix(), XLS_SUFFIX);
        this.writeToFile(summary, logFile);
        return logFile;
    }

    protected abstract String getImportLogPrefix();

    protected abstract Logger getLogger();

    protected abstract Map<String, EntityType> getEntityTypeByTab();
}

