/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.entitypath;

import java.util.Collections;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.internal.library.EntityPathHeaderService;

@RestController
@RequestMapping(value={"/backend/entity-path-header"})
public class EntityPathHeaderController {
    private static final String PATH = "path";
    private final EntityPathHeaderService entityPathHeaderService;

    public EntityPathHeaderController(EntityPathHeaderService entityPathHeaderService) {
        this.entityPathHeaderService = entityPathHeaderService;
    }

    @GetMapping(value={"campaign/{campaignId}"})
    Map<String, String> getCampaignPathHeader(@PathVariable Long campaignId) {
        return Collections.singletonMap(PATH, this.entityPathHeaderService.buildCLNPathHeader(campaignId));
    }

    @GetMapping(value={"campaign-folder/{campaignFolderId}"})
    Map<String, String> getCampaignFolderPathHeader(@PathVariable Long campaignFolderId) {
        return Collections.singletonMap(PATH, this.entityPathHeaderService.buildCLNPathHeader(campaignFolderId));
    }

    @GetMapping(value={"iteration/{iterationId}"})
    Map<String, String> getIterationPathHeader(@PathVariable Long iterationId) {
        return Collections.singletonMap(PATH, this.entityPathHeaderService.buildIterationPathHeader(iterationId));
    }

    @GetMapping(value={"test-case/{testCaseId}"})
    Map<String, String> getTestCasePathHeader(@PathVariable Long testCaseId) {
        return Collections.singletonMap(PATH, this.entityPathHeaderService.buildTCLNPathHeader(testCaseId));
    }

    @GetMapping(value={"test-case-folder/{testCaseFolderId}"})
    Map<String, String> getTestCaseFolderPathHeader(@PathVariable Long testCaseFolderId) {
        return Collections.singletonMap(PATH, this.entityPathHeaderService.buildTCLNPathHeader(testCaseFolderId));
    }

    @GetMapping(value={"requirement/{requirementId}"})
    Map<String, String> getRequirementPathHeader(@PathVariable Long requirementId) {
        return Collections.singletonMap(PATH, this.entityPathHeaderService.buildRLNPathHeader(requirementId));
    }

    @GetMapping(value={"requirement-folder/{requirementFolderId}"})
    Map<String, String> getRequirementFolderPathHeader(@PathVariable Long requirementFolderId) {
        return Collections.singletonMap(PATH, this.entityPathHeaderService.buildRLNPathHeader(requirementFolderId));
    }
}

