/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import java.util.Collections;
import java.util.Locale;
import javax.inject.Named;
import javax.inject.Provider;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.users.PartyPreference;
import org.squashtest.tm.domain.users.preferences.CorePartyPreference;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.customreport.CustomReportDashboardService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.internal.display.dto.customreports.CustomReportDashboardDto;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportDashboard;
import org.squashtest.tm.service.statistics.campaign.StatisticsBundle;
import org.squashtest.tm.service.user.PartyPreferenceService;
import org.squashtest.tm.web.backend.model.builder.JsonCustomReportDashboardBuilder;

@RestController
@RequestMapping(value={"/backend/campaign-milestone-dashboard"})
public class CampaignMilestoneDashboardController {
    private final CampaignLibraryNavigationService campaignLibraryNavigationService;
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    @Named(value="customReport.dashboardBuilder")
    private final Provider<JsonCustomReportDashboardBuilder> builderProvider;
    private final CustomReportDashboardService customReportDashboardService;
    private final PartyPreferenceService partyPreferenceService;

    public CampaignMilestoneDashboardController(CampaignLibraryNavigationService campaignLibraryNavigationService, CustomReportLibraryNodeService customReportLibraryNodeService, Provider<JsonCustomReportDashboardBuilder> builderProvider, CustomReportDashboardService customReportDashboardService, PartyPreferenceService partyPreferenceService) {
        this.campaignLibraryNavigationService = campaignLibraryNavigationService;
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.builderProvider = builderProvider;
        this.customReportDashboardService = customReportDashboardService;
        this.partyPreferenceService = partyPreferenceService;
    }

    @GetMapping
    public CampaignMilestoneDashboard getDashboardByMilestone(Locale locale, @RequestParam boolean lastExecutionScope) {
        CampaignMilestoneDashboard campaignMilestoneDashboard = new CampaignMilestoneDashboard();
        boolean canShowDashboardInWorkspace = this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.CAMPAIGN);
        boolean shouldShowFavoriteDashboardInWorkspace = this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.CAMPAIGN);
        campaignMilestoneDashboard.setCanShowFavoriteDashboard(canShowDashboardInWorkspace);
        campaignMilestoneDashboard.setShouldShowFavoriteDashboard(shouldShowFavoriteDashboardInWorkspace);
        if (shouldShowFavoriteDashboardInWorkspace) {
            if (canShowDashboardInWorkspace) {
                PartyPreference preference = this.partyPreferenceService.findPreferenceForCurrentUser(CorePartyPreference.FAVORITE_DASHBOARD_CAMPAIGN.getPreferenceKey());
                Long dashboardId = Long.valueOf(preference.getPreferenceValue());
                CustomReportDashboard dashboard = this.customReportLibraryNodeService.findCustomReportDashboardById(dashboardId);
                CustomReportDashboardDto dto = new CustomReportDashboardDto(Workspace.CAMPAIGN, Collections.emptyList(), true, false, lastExecutionScope);
                JsonCustomReportDashboard jsonDashboard = ((JsonCustomReportDashboardBuilder)this.builderProvider.get()).build(dashboardId, dashboard, locale, dto);
                campaignMilestoneDashboard.setDashboard(jsonDashboard);
                campaignMilestoneDashboard.setFavoriteDashboardId(dashboardId);
            }
        } else {
            campaignMilestoneDashboard.setStatistics(this.campaignLibraryNavigationService.gatherCampaignStatisticsBundleByMilestone(lastExecutionScope));
        }
        return campaignMilestoneDashboard;
    }

    static class CampaignMilestoneDashboard {
        private StatisticsBundle statistics;
        private JsonCustomReportDashboard dashboard;
        private boolean shouldShowFavoriteDashboard;
        private boolean canShowFavoriteDashboard;
        private Long favoriteDashboardId;

        CampaignMilestoneDashboard() {
        }

        public StatisticsBundle getStatistics() {
            return this.statistics;
        }

        public void setStatistics(StatisticsBundle statistics) {
            this.statistics = statistics;
        }

        public JsonCustomReportDashboard getDashboard() {
            return this.dashboard;
        }

        public void setDashboard(JsonCustomReportDashboard dashboard) {
            this.dashboard = dashboard;
        }

        public boolean isShouldShowFavoriteDashboard() {
            return this.shouldShowFavoriteDashboard;
        }

        public void setShouldShowFavoriteDashboard(boolean shouldShowFavoriteDashboard) {
            this.shouldShowFavoriteDashboard = shouldShowFavoriteDashboard;
        }

        public boolean isCanShowFavoriteDashboard() {
            return this.canShowFavoriteDashboard;
        }

        public void setCanShowFavoriteDashboard(boolean canShowFavoriteDashboard) {
            this.canShowFavoriteDashboard = canShowFavoriteDashboard;
        }

        public Long getFavoriteDashboardId() {
            return this.favoriteDashboardId;
        }

        public void setFavoriteDashboardId(Long favoriteDashboardId) {
            this.favoriteDashboardId = favoriteDashboardId;
        }
    }
}

