/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.service.library.FolderModificationService;

@RestController
@RequestMapping(value={"backend/campaign-folder/{campaignId}"})
public class CampaignFolderModificationController {
    private FolderModificationService<CampaignFolder> folderFolderModificationService;

    public CampaignFolderModificationController(FolderModificationService<CampaignFolder> folderFolderModificationService) {
        this.folderFolderModificationService = folderFolderModificationService;
    }

    @ResponseBody
    @PostMapping(value={"/description"})
    public void changeDescription(@PathVariable Long campaignId, @RequestBody CampaignFolderPatch patch) {
        this.folderFolderModificationService.updateFolderDescription(campaignId.longValue(), patch.getDescription());
    }

    @ResponseBody
    @PostMapping(value={"/name"})
    public void changeName(@PathVariable Long campaignId, @RequestBody CampaignFolderPatch patch) {
        this.folderFolderModificationService.renameFolder(campaignId.longValue(), patch.getName());
    }

    static class CampaignFolderPatch {
        private String name;
        private String description;

        CampaignFolderPatch() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

