/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.artificialintelligence.server;

import java.util.Date;
import java.util.Map;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.service.artificialintelligence.server.AiServerManagerService;
import org.squashtest.tm.service.artificialintelligence.testcasegeneration.AiTestCaseGenerationService;
import org.squashtest.tm.service.display.artificialintelligence.server.AiServerDisplayService;
import org.squashtest.tm.service.internal.display.dto.AiServerAdminViewDto;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.thirdpartyserver.ThirdPartyServerCredentialsService;
import org.squashtest.tm.web.backend.controller.utils.UrlValidator;

@Controller
@RequestMapping(value={"/backend/ai-server"})
public class AiServerViewController {
    private final AiServerDisplayService aiServerDisplayService;
    private final AiServerManagerService aiServerManagerService;
    private final ThirdPartyServerCredentialsService thirdPartyServerCredentialsService;
    private final AiTestCaseGenerationService aiTestCaseGenerationService;

    public AiServerViewController(AiServerDisplayService aiServerDisplayService, AiServerManagerService aiServerManagerService, ThirdPartyServerCredentialsService thirdPartyServerCredentialsService, AiTestCaseGenerationService aiTestCaseGenerationService) {
        this.aiServerDisplayService = aiServerDisplayService;
        this.aiServerManagerService = aiServerManagerService;
        this.thirdPartyServerCredentialsService = thirdPartyServerCredentialsService;
        this.aiTestCaseGenerationService = aiTestCaseGenerationService;
    }

    @GetMapping(value={"/{aiServerId}"})
    @ResponseBody
    public AiServerAdminViewDto getAiServerView(@PathVariable Long aiServerId) {
        return this.aiServerDisplayService.getAiServerView(aiServerId);
    }

    @PostMapping(value={"/{aiServerId}/name"})
    @ResponseBody
    public void updateName(@PathVariable long aiServerId, @RequestBody AiServerRecord aiServerRecord) {
        this.aiServerManagerService.updateName(aiServerId, aiServerRecord.name);
    }

    @PostMapping(value={"/{aiServerId}/description"})
    @ResponseBody
    public void updateDescription(@PathVariable long aiServerId, @RequestBody AiServerRecord aiServerRecord) {
        this.aiServerManagerService.updateDescription(aiServerId, aiServerRecord.description);
    }

    @PostMapping(value={"/{aiServerId}/url"})
    @ResponseBody
    public void updateUrl(@PathVariable long aiServerId, @RequestBody AiServerRecord aiServerRecord) {
        UrlValidator.checkURL(aiServerRecord.url);
        this.aiServerManagerService.updateUrl(aiServerId, aiServerRecord.url);
    }

    @PostMapping(value={"/{aiServerId}/credentials"})
    @ResponseBody
    public void storeCredentials(@PathVariable long aiServerId, @RequestBody ManageableCredentials credentials) {
        this.thirdPartyServerCredentialsService.storeCredentials(aiServerId, credentials);
        this.aiServerManagerService.forceAuditAfterCredentialsUpdate(aiServerId);
    }

    @DeleteMapping(value={"/{aiServerId}/credentials"})
    @ResponseBody
    public void deleteCredentials(@PathVariable long aiServerId) {
        this.thirdPartyServerCredentialsService.deleteCredentials(aiServerId);
    }

    @PostMapping(value={"/{aiServerId}/new-payload"})
    @ResponseBody
    public void updatePayloadTemplate(@PathVariable long aiServerId, @RequestBody AiServerRecord aiServerRecord) {
        this.aiServerManagerService.updatePayloadTemplate(aiServerId, aiServerRecord.payload);
    }

    @ResponseBody
    @PostMapping(value={"/{aiServerId}/test-api"})
    public String generateTestCaseFromRequirementUsingAi(@PathVariable long aiServerId, @RequestBody Map<String, String> payloadRequestBody) {
        return this.aiTestCaseGenerationService.testAiServerConfiguration(aiServerId, payloadRequestBody.get("requirementDescription"));
    }

    @PostMapping(value={"/{aiServerId}/new-jsonpath"})
    @ResponseBody
    public void updateJsonPath(@PathVariable long aiServerId, @RequestBody AiServerRecord aiServerRecord) {
        this.aiServerManagerService.updateJsonPath(aiServerId, aiServerRecord.jsonPath);
    }

    record AiServerRecord(String name, String url, String description, String createdBy, Date createdOn, String lastModifiedBy, Date lastModifiedOn, String payload, String requirement, String jsonPath) {
    }
}

