/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.HttpBasicConfigurer;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.firewall.StrictHttpFirewall;
import org.springframework.security.web.session.HttpSessionEventPublisher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.squashtest.tm.api.security.authentication.ApiSecurityExemptionEndPoint;
import org.squashtest.tm.api.security.authentication.SecurityExemptionEndPoint;
import org.squashtest.tm.web.config.AngularAppPageUrls;
import org.squashtest.tm.web.config.MainEntryPoint;
import org.squashtest.tm.web.security.authentication.SinglePageAppAuthenticationFailureHandler;
import org.squashtest.tm.web.security.authentication.SinglePageAppAuthenticationSuccessHandler;

@Configuration
public class WebSecurityConfig {
    private static final String ALTERNATE_AUTH_PATH = "/auth/**";
    private static final String LOGIN = "/login";
    private static final String LOGOUT = "/logout";
    private static final String ROOT_PATH = "/";
    private static final String CONTROLLERS_ROOT_URL = "/backend";
    private static final String[] ADMIN_OR_PROJECT_MANAGER_URLS = new String[]{"/backend/project-view/**", "/backend/generic-projects/**", "/backend/custom-field-binding/**", "/backend/environment-variables/**", "/backend/milestones/**", "/backend/milestone-view/**", "/backend/milestone-binding/**", "/backend/scm-repositories/**", "/backend/info-list-binding/**", "/backend/referential/admin", "/backend/system-view/**", "/backend/orchestrator-operation/**"};
    private static final String[] ADMIN_ONLY_URLS = new String[]{"/backend/ai-servers/**", "/backend/bugtracker/**", "/backend/bugtrackers/**", "/backend/custom-field-view/**", "/backend/environment-variable-view/**", "/backend/info-list-items/**", "/backend/info-list-view/**", "/backend/info-lists/**", "/backend/project-templates/**", "/backend/projects/**", "/backend/requirement-link-type/**", "/backend/requirements-links/**", "/backend/scm-server-view/**", "/backend/scm-servers/**", "/backend/system/**", "/backend/team-view/**", "/backend/teams/**", "/backend/test-automation-servers/**", "/backend/user-view/**", "/backend/users/**", "/backend/users/**"};

    @Configuration
    @Order(value=20)
    public static class ApiWebSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        @Value(value="${squash.security.basic.token-charset}")
        private String basicAuthCharset = "ISO-8859-1";
        @Autowired(required=false)
        private final Collection<ApiSecurityExemptionEndPoint> apiSecurityExemptionEndPoints = Collections.emptyList();

        public void configure(WebSecurity webSecurity) {
            webSecurity.ignoring().antMatchers(this.gatherIgnoringAuthUrlPatterns());
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)((HttpBasicConfigurer)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().antMatchers(this.gatherIgnoringAuthUrlPatterns())).permitAll().and()).antMatcher("/api/**").authorizeRequests().anyRequest()).authenticated().and()).httpBasic().withObjectPostProcessor((ObjectPostProcessor)new BasicAuthCharsetConfigurer(this.basicAuthCharset))).realmName("squash-api").authenticationEntryPoint(new AuthenticationEntryPoint(){

                public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException {
                    response.addHeader("WWW-Authenticate", "Basic realm=\"squah-api\"");
                    response.addHeader("Content-Type", "application/json");
                    response.sendError(401, String.valueOf(authException.getMessage()) + ". You may authenticate using " + "1/ basic authentication or " + "2/ fetching a cookie JSESSIONID from /login");
                }
            }).and()).logout().permitAll().logoutRequestMatcher((RequestMatcher)new AntPathRequestMatcher(WebSecurityConfig.LOGOUT)).invalidateHttpSession(true).logoutSuccessUrl(WebSecurityConfig.ROOT_PATH);
        }

        private String[] gatherIgnoringAuthUrlPatterns() {
            ArrayList result = new ArrayList();
            for (ApiSecurityExemptionEndPoint endPoint : this.apiSecurityExemptionEndPoints) {
                result.addAll(endPoint.getIgnoreAuthUrlPatterns());
            }
            return result.toArray(new String[0]);
        }
    }

    private static final class BasicAuthCharsetConfigurer
    implements ObjectPostProcessor<BasicAuthenticationFilter> {
        private final String charset;

        public BasicAuthCharsetConfigurer(String charset) {
            this.charset = charset;
        }

        public <O extends BasicAuthenticationFilter> O postProcess(O object) {
            object.setCredentialsCharset(this.charset);
            return object;
        }
    }

    @Configuration
    @Order(value=10)
    public static class SquashTAWebSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        @Value(value="${squash.security.basic.token-charset}")
        private String basicAuthCharset = "ISO-8859-1";

        @Bean
        public AuthenticationManager authenticationManagerBean() throws Exception {
            return super.authenticationManagerBean();
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).antMatcher("/automated-executions/**").authorizeRequests().anyRequest()).access("hasRole('ROLE_TA_API_CLIENT')").and()).httpBasic().withObjectPostProcessor((ObjectPostProcessor)new BasicAuthCharsetConfigurer(this.basicAuthCharset));
        }
    }

    @Configuration
    @Order(value=30)
    public static class StandardWebSecurityConfigurerAdapter
    extends WebSecurityConfigurerAdapter {
        private static final List<String> DEFAULT_IGNORE_AUTH_URLS = Arrays.asList("/", "/login", "/auth/**", "/logout", "/logged-out");
        @Autowired(required=false)
        private Collection<SecurityExemptionEndPoint> securityExemptionEndPoints = Collections.emptyList();
        @Value(value="${squash.security.filter.debug.enabled:false}")
        private boolean debugSecurityFilter;
        @Value(value="${squash.security.preferred-auth-url:/login}")
        private String entryPointUrl = "/login";
        @Value(value="${squash.security.ignored:/scripts/**}")
        private String[] secIngored;

        @Bean
        public SessionRegistry sessionRegistry() {
            return new SessionRegistryImpl();
        }

        @Bean
        public HttpSessionEventPublisher httpSessionEventPublisher() {
            return new HttpSessionEventPublisher();
        }

        public void configure(WebSecurity web) throws Exception {
            ((WebSecurity.IgnoredRequestConfigurer)web.debug(this.debugSecurityFilter).ignoring().antMatchers(this.secIngored)).and().httpFirewall(this.customHttpFirewall());
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.headers().frameOptions().sameOrigin().and()).csrf().csrfTokenRepository((CsrfTokenRepository)CookieCsrfTokenRepository.withHttpOnlyFalse()).ignoringAntMatchers(this.gatherIgnoringCsrfUrlPatterns()).and()).httpBasic().and()).authorizeRequests().antMatchers(this.gatherIgnoringAuthUrlPatterns())).permitAll().antMatchers(new String[]{"/backend/login", "/backend/logout", "/backend/login-page", "/backend/version", "/index.html", WebSecurityConfig.LOGIN, "/favicon.ico"})).permitAll().antMatchers(new String[]{"/plugin/**", "/index"})).permitAll().antMatchers(AngularAppPageUrls.getAllUrlsPatterns())).permitAll().antMatchers(new String[]{"/*.js", "/**/*.js", "/**/*.json", "/*.js.map", "/**/*.js.map", "/resources/**", "/*.css", "/*.ts", "/*.ttf", "/assets/**"})).permitAll().antMatchers(ADMIN_OR_PROJECT_MANAGER_URLS)).access("hasRole('ROLE_ADMIN') or hasRole('ROLE_TM_PROJECT_MANAGER')").antMatchers(ADMIN_ONLY_URLS)).access("hasRole('ROLE_ADMIN')").anyRequest()).authenticated().and()).exceptionHandling().authenticationEntryPoint(this.mainEntryPoint()).and()).formLogin().loginProcessingUrl("/backend/login")).successHandler((AuthenticationSuccessHandler)this.singlePageAppAuthenticationSuccessHandler())).failureHandler((AuthenticationFailureHandler)this.singlePageAppAuthenticationFailureHandler())).and()).sessionManagement().maximumSessions(-1).sessionRegistry(this.sessionRegistry());
        }

        @Bean
        public SinglePageAppAuthenticationSuccessHandler singlePageAppAuthenticationSuccessHandler() {
            return new SinglePageAppAuthenticationSuccessHandler();
        }

        @Bean
        public SinglePageAppAuthenticationFailureHandler singlePageAppAuthenticationFailureHandler() {
            return new SinglePageAppAuthenticationFailureHandler();
        }

        @Bean
        public AuthenticationEntryPoint mainEntryPoint() {
            return new MainEntryPoint(this.entryPointUrl);
        }

        private String[] gatherIgnoringCsrfUrlPatterns() {
            ArrayList<String> result = new ArrayList<String>(Collections.singletonList(WebSecurityConfig.ALTERNATE_AUTH_PATH));
            for (SecurityExemptionEndPoint endPoint : this.securityExemptionEndPoints) {
                result.addAll(endPoint.getIgnoreCsrfUrlPatterns());
            }
            return result.toArray(new String[0]);
        }

        @Bean
        public HttpFirewall customHttpFirewall() {
            StrictHttpFirewall firewall = new StrictHttpFirewall();
            firewall.setAllowSemicolon(true);
            firewall.setAllowUrlEncodedPercent(true);
            return firewall;
        }

        private String[] gatherIgnoringAuthUrlPatterns() {
            ArrayList<String> result = new ArrayList<String>(DEFAULT_IGNORE_AUTH_URLS);
            for (SecurityExemptionEndPoint endPoint : this.securityExemptionEndPoints) {
                result.addAll(endPoint.getIgnoreAuthUrlPatterns());
            }
            return result.toArray(new String[0]);
        }
    }
}

