/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.report.Report;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.form.CheckboxInput;
import org.squashtest.tm.api.report.form.CheckboxesGroup;
import org.squashtest.tm.api.report.form.ContainerOption;
import org.squashtest.tm.api.report.form.DateInput;
import org.squashtest.tm.api.report.form.DropdownList;
import org.squashtest.tm.api.report.form.Input;
import org.squashtest.tm.api.report.form.InputType;
import org.squashtest.tm.api.report.form.InputsGroup;
import org.squashtest.tm.api.report.form.OptionInput;
import org.squashtest.tm.api.report.form.RadioButtonsGroup;
import org.squashtest.tm.api.report.form.TemplateDropdownList;
import org.squashtest.tm.api.report.form.TextInput;
import org.squashtest.tm.api.report.form.TreePicker;
import org.squashtest.tm.api.utils.CurrentUserHelper;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.service.display.campaign.CampaignDisplayService;
import org.squashtest.tm.service.display.campaign.IterationDisplayService;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.milestone.MilestoneManagerService;
import org.squashtest.tm.service.project.CustomProjectModificationService;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.web.backend.helper.JsonHelper;
import org.squashtest.tm.web.backend.report.IdentifiedReportDecorator;
import org.squashtest.tm.web.backend.report.ReportsRegistry;
import org.squashtest.tm.web.backend.report.criteria.ConciseFormToCriteriaConverter;
import org.squashtest.tm.web.backend.report.criteria.EmptyCriteria;
import org.squashtest.tm.web.backend.report.criteria.MultiOptionsCriteria;
import org.squashtest.tm.web.backend.report.criteria.MultiValuesCriteria;
import org.squashtest.tm.web.backend.report.criteria.SimpleCriteria;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Component
public class ReportHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportHelper.class);
    private static final String REQUIREMENTS_IDS = "requirementsIds";
    private static final String TESTCASES_IDS = "testcasesIds";
    private static final String CAMPAIGN_IDS = "campaignIds";
    private static final String CAMPAIGN_ID = "campaignId";
    private static final String ITERATION_IDS = "iterationIds";
    private static final String ITERATION_ID = "iterationId";
    private static final String PROJECT_IDS = "projectIds";
    private static final String MILESTONES = "milestones";
    private static final String TAGS = "tags";
    private static final String OPTION = "option";
    @Inject
    private CampaignDisplayService campaignDisplayService;
    @Inject
    private IterationDisplayService iterationDisplayService;
    @Inject
    private RequirementVersionManagerService requirementVersionManagerService;
    @Inject
    private TestCaseModificationService testCaseModificationService;
    @Inject
    private MilestoneManagerService milestoneManagerService;
    @Inject
    private ReportsRegistry reportsRegistry;
    @Inject
    private InternationalizationHelper i18nHelper;
    @Inject
    private CustomProjectModificationService customProjectModificationService;
    @Inject
    private UltimateLicenseAvailabilityService ultimateLicenseService;
    @Inject
    private CurrentUserHelper currentUserHelper;

    public Map<String, List<String>> getAttributesFromReportDefinition(ReportDefinition def) {
        IdentifiedReportDecorator report = this.reportsRegistry.findReport(def.getPluginNamespace());
        Map<String, Object> form = null;
        try {
            form = JsonHelper.deserialize(def.getParameters());
        }
        catch (IOException e) {
            LOGGER.error("the report : " + def.getName() + " has corrupted parameters.", (Throwable)e);
        }
        Map<String, Criteria> crit = new ConciseFormToCriteriaConverter(report, Collections.singletonList(def.getProject().getId())).convert(form);
        List projectIds = this.currentUserHelper.findReadableProjectIds();
        return this.getAttributesForReport(report, crit, projectIds);
    }

    public Map<String, List<String>> getAttributesForReport(Report report, Map<String, Criteria> criteriaMap, List<Long> projectIds) {
        Input[] inputs;
        LinkedHashMap<String, List<String>> attributes = new LinkedHashMap<String, List<String>>();
        Input[] inputArray = inputs = report.getForm();
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            Input input = inputArray[n2];
            this.getAttributesFromInput(attributes, input, criteriaMap, projectIds);
            ++n2;
        }
        return attributes;
    }

    private void getAttributesFromInput(Map<String, List<String>> attributes, Input input, Map<String, Criteria> criteriaMap, List<Long> projectIds) {
        switch (input.getType()) {
            case RADIO_BUTTONS_GROUP: {
                this.getAttributesFromRadioButtonsGroup(attributes, input, criteriaMap, projectIds);
                break;
            }
            case CHECKBOXES_GROUP: {
                this.getAttributesFromChexBoxesGroup(attributes, input, criteriaMap);
                break;
            }
            case INPUTS_GROUP: {
                this.getAttributesFromInputsGroup(attributes, input, criteriaMap, projectIds);
                break;
            }
            case CHECKBOX: {
                this.getAttributesFromCheckBox(attributes, input, criteriaMap, projectIds);
                break;
            }
            case DATE: {
                this.getAttributesFromDate(attributes, input, criteriaMap);
                break;
            }
            case TEXT: {
                this.getAttributesFromText(attributes, input, criteriaMap);
                break;
            }
            case DROPDOWN_LIST: {
                this.getAttributesFromDropdownList(attributes, input, criteriaMap);
                break;
            }
            case TEMPLATE_DROPDOWN_LIST: {
                this.getAttributesFromTemplateDropdownList(attributes, input, criteriaMap);
                break;
            }
            case TREE_PICKER: {
                this.getAttributesFromTreePicker(attributes, input, criteriaMap, projectIds);
                break;
            }
            case PROJECT_PICKER: 
            case MILESTONE_PICKER: 
            case TAG_PICKER: {
                this.getAttributesFromPickers(attributes, input, criteriaMap, projectIds);
                break;
            }
        }
    }

    private void getAttributesFromRadioButtonsGroup(Map<String, List<String>> attributes, Input input, Map<String, Criteria> criteriaMap, List<Long> projectIds) {
        RadioButtonsGroup radioButtonsGroup = (RadioButtonsGroup)input;
        SimpleCriteria<String> sCrit = this.retrieveCriteriaFromMap(radioButtonsGroup.getName(), radioButtonsGroup.getOptions(), criteriaMap);
        if (Objects.nonNull(sCrit)) {
            radioButtonsGroup.getOptions().forEach(optionInput -> {
                if (optionInput.getValue().equalsIgnoreCase((String)sCrit.getValue())) {
                    this.getAttributesFromOptionInput(attributes, (OptionInput)optionInput, criteriaMap, projectIds);
                }
            });
        }
    }

    private SimpleCriteria<String> retrieveCriteriaFromMap(String radioButtonsGroupName, List<OptionInput> options, Map<String, Criteria> criteriaMap) {
        SimpleCriteria<String> crit = (SimpleCriteria<String>)criteriaMap.get(radioButtonsGroupName);
        return Objects.nonNull(crit) ? crit : this.createDefaultCriteriaFromOptions(radioButtonsGroupName, options);
    }

    private SimpleCriteria<String> createDefaultCriteriaFromOptions(String radioButtonsGroupName, List<OptionInput> options) {
        OptionInput defaultOption = this.findDefaultSelectedOption(options);
        return Objects.nonNull(defaultOption) ? new SimpleCriteria<String>(radioButtonsGroupName, defaultOption.getValue(), InputType.RADIO_BUTTONS_GROUP) : null;
    }

    private OptionInput findDefaultSelectedOption(List<OptionInput> options) {
        return options.stream().filter(OptionInput::isDefaultSelected).findFirst().orElse(null);
    }

    private void getAttributesFromChexBoxesGroup(Map<String, List<String>> attributes, Input input, Map<String, Criteria> criteriaMap) {
        CheckboxesGroup checkboxesGroup = (CheckboxesGroup)input;
        MultiOptionsCriteria moCrit = (MultiOptionsCriteria)criteriaMap.get(checkboxesGroup.getName());
        checkboxesGroup.getOptions().forEach(optionInput -> {
            if (Objects.nonNull(moCrit)) {
                moCrit.getSelectedOptions().forEach(selectedOption -> {
                    if (optionInput.getValue().equalsIgnoreCase(selectedOption.toString())) {
                        List checkedAttributes = attributes.computeIfAbsent(checkboxesGroup.getLabel(), k -> new ArrayList());
                        checkedAttributes.add(optionInput.getLabel());
                    }
                });
            } else if (optionInput.isDefaultSelected()) {
                List checkedAttributes = attributes.computeIfAbsent(checkboxesGroup.getLabel(), k -> new ArrayList());
                checkedAttributes.add(optionInput.getLabel());
            }
        });
    }

    private void getAttributesFromInputsGroup(Map<String, List<String>> attributes, Input input, Map<String, Criteria> criteriaMap, List<Long> projectIds) {
        InputsGroup inputsGroup = (InputsGroup)input;
        inputsGroup.getInputs().forEach(i -> this.getAttributesFromInput(attributes, (Input)i, criteriaMap, projectIds));
    }

    private void getAttributesFromCheckBox(Map<String, List<String>> attributes, Input input, Map<String, Criteria> criteriaMap, List<Long> projectIds) {
        CheckboxInput checkboxInput = (CheckboxInput)input;
        SimpleCriteria sCrit = (SimpleCriteria)criteriaMap.get(checkboxInput.getName());
        if (((Boolean)sCrit.getValue()).booleanValue()) {
            this.getAttributesFromOptionInput(attributes, (OptionInput)checkboxInput, criteriaMap, projectIds);
        }
    }

    private void getAttributesFromDropdownList(Map<String, List<String>> attributes, Input input, Map<String, Criteria> criteriaMap) {
        DropdownList dropdownList = (DropdownList)input;
        SimpleCriteria sCrit = (SimpleCriteria)criteriaMap.get(dropdownList.getName());
        dropdownList.getOptions().forEach(optionInput -> {
            if (optionInput.getValue().equalsIgnoreCase((String)sCrit.getValue())) {
                attributes.put(dropdownList.getLabel(), Arrays.asList(optionInput.getLabel()));
            }
        });
    }

    private void getAttributesFromTemplateDropdownList(Map<String, List<String>> attributes, Input input, Map<String, Criteria> criteriaMap) {
        TemplateDropdownList templateDropdownList = (TemplateDropdownList)input;
        Criteria criteria = criteriaMap.get(templateDropdownList.getName());
        List opts = templateDropdownList.getOptions();
        String attributeValue = this.retrieveAttributeValueForTemplateDropdownList(criteria, templateDropdownList, opts);
        attributes.put(templateDropdownList.getLabel(), Collections.singletonList(attributeValue));
    }

    private String retrieveAttributeValueForTemplateDropdownList(Criteria criteria, TemplateDropdownList templateDropdownList, List<OptionInput> opts) {
        if (criteria instanceof EmptyCriteria) {
            return this.retrieveTemplateDropdownListAttributeValueIfDoesNotExist(templateDropdownList);
        }
        Optional<OptionInput> defaultOption = opts.stream().filter(OptionInput::isDefaultSelected).findFirst();
        if (defaultOption.isEmpty()) {
            throw new IllegalArgumentException(String.format("You must define a default value for TemplateDropdownList: %s", templateDropdownList.getLabel()));
        }
        return this.retrieveTemplateDropdownListAttributeValueIfExists(criteria, defaultOption.get(), templateDropdownList, opts);
    }

    private String retrieveTemplateDropdownListAttributeValueIfDoesNotExist(TemplateDropdownList templateDropdownList) {
        return this.displayLicenseMessageIfCannotManageTemplate() ? templateDropdownList.getLicenseMessageOnReportView() : templateDropdownList.getFileDoesNotExistMessage();
    }

    private String retrieveTemplateDropdownListAttributeValueIfExists(Criteria criteria, OptionInput defaultOption, TemplateDropdownList templateDropdownList, List<OptionInput> opts) {
        SimpleCriteria sCrit = (SimpleCriteria)criteria;
        return Objects.isNull(sCrit) ? defaultOption.getLabel() : this.doRetrieveTemplateDropdownListAttributeValueIfExists(sCrit, defaultOption.getValue(), templateDropdownList, opts);
    }

    private String doRetrieveTemplateDropdownListAttributeValueIfExists(SimpleCriteria sCrit, String defaultOptionValue, TemplateDropdownList templateDropdownList, List<OptionInput> opts) {
        if (!sCrit.getValue().equals(defaultOptionValue) && this.displayLicenseMessageIfCannotManageTemplate()) {
            return templateDropdownList.getLicenseMessageOnReportView();
        }
        Optional<OptionInput> foundOption = opts.stream().filter(opt -> opt.getValue().equalsIgnoreCase((String)sCrit.getValue())).findFirst();
        if (foundOption.isPresent()) {
            return foundOption.get().getLabel();
        }
        return "";
    }

    private boolean displayLicenseMessageIfCannotManageTemplate() {
        return !this.ultimateLicenseService.isAvailable();
    }

    private void getAttributesFromTreePicker(Map<String, List<String>> attributes, Input input, Map<String, Criteria> criteriaMap, List<Long> projectIds) {
        TreePicker treePicker = (TreePicker)input;
        MultiValuesCriteria mvCrit = (MultiValuesCriteria)criteriaMap.get(treePicker.getName());
        ArrayList<String> targets = new ArrayList<String>(mvCrit.getValue().values());
        this.getAttributesFromPicker(attributes, targets, mvCrit.getName(), projectIds);
    }

    private void getAttributesFromPickers(Map<String, List<String>> attributes, Input input, Map<String, Criteria> criteriaMap, List<Long> projectIds) {
        MultiOptionsCriteria moCrit = (MultiOptionsCriteria)criteriaMap.get(input.getName());
        ArrayList<String> targets = new ArrayList<String>();
        moCrit.getSelectedOptions().forEach(o -> {
            boolean bl = targets.add(o.toString());
        });
        this.getAttributesFromPicker(attributes, targets, moCrit.getName(), projectIds);
    }

    private void getAttributesFromDate(Map<String, List<String>> attributes, Input input, Map<String, Criteria> criteriaMap) {
        DateInput dateInput = (DateInput)input;
        Criteria crit = criteriaMap.get(dateInput.getName());
        Locale locale = LocaleContextHolder.getLocale();
        if (crit instanceof SimpleCriteria) {
            SimpleCriteria sCrit = (SimpleCriteria)crit;
            Date date = (Date)sCrit.getValue();
            attributes.put(dateInput.getLabel(), Arrays.asList(this.i18nHelper.localizeShortDate(date, locale)));
        } else {
            attributes.put(dateInput.getLabel(), Arrays.asList("-"));
        }
    }

    private void getAttributesFromText(Map<String, List<String>> attributes, Input input, Map<String, Criteria> criteriaMap) {
        TextInput textInput = (TextInput)input;
        Criteria crit = criteriaMap.get(textInput.getName());
        if (crit instanceof SimpleCriteria) {
            SimpleCriteria sCrit = (SimpleCriteria)crit;
            String text = (String)sCrit.getValue();
            attributes.put(textInput.getLabel(), Arrays.asList(text));
        } else {
            attributes.put(textInput.getLabel(), Arrays.asList("-"));
        }
    }

    private void getAttributesFromOptionInput(Map<String, List<String>> attributes, OptionInput optionInput, Map<String, Criteria> criteriaMap, List<Long> projectIds) {
        ArrayList<String> options = new ArrayList<String>();
        if (optionInput instanceof ContainerOption) {
            ContainerOption containerOption = (ContainerOption)optionInput;
            this.getAttributesFromInput(attributes, containerOption.getContent(), criteriaMap, projectIds);
        } else if (attributes.get(OPTION) == null) {
            attributes.put(OPTION, Arrays.asList(optionInput.getLabel()));
        } else {
            options.addAll((Collection)attributes.get(OPTION));
            options.add(optionInput.getLabel());
            attributes.put(OPTION, options);
        }
    }

    private void getAttributesFromPicker(Map<String, List<String>> attributes, List<String> targetIds, String entity, List<Long> projectIds) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Long> ids = new ArrayList<Long>();
        Locale locale = LocaleContextHolder.getLocale();
        String entityLabelKey = "";
        switch (entity) {
            case "campaignId": {
                entityLabelKey = "label.Campaign";
            }
            case "campaignIds": {
                targetIds.forEach(id -> {
                    boolean bl = ids.add(Long.parseLong(id));
                });
                this.handleAttributesForCampaignIds(attributes, names, ids, locale, entityLabelKey, projectIds);
                break;
            }
            case "iterationId": {
                entityLabelKey = "label.iteration";
            }
            case "iterationIds": {
                targetIds.forEach(id -> {
                    boolean bl = ids.add(Long.parseLong(id));
                });
                this.handleAttributesForIterationIds(attributes, names, ids, locale, entityLabelKey, projectIds);
                break;
            }
            case "requirementsIds": {
                targetIds.forEach(id -> {
                    boolean bl = ids.add(Long.parseLong(id));
                });
                this.handleAttributesForRequirementIds(attributes, names, ids, locale, projectIds);
                break;
            }
            case "testcasesIds": {
                targetIds.forEach(id -> {
                    boolean bl = ids.add(Long.parseLong(id));
                });
                this.handleAttributesForTestCaseIds(attributes, names, ids, locale, projectIds);
                break;
            }
            case "projectIds": {
                targetIds.forEach(id -> {
                    boolean bl = ids.add(Long.parseLong(id));
                });
                this.handleAttributesForProjectIds(attributes, names, ids, locale);
                break;
            }
            case "milestones": {
                targetIds.forEach(id -> {
                    boolean bl = ids.add(Long.parseLong(id));
                });
                this.handleAttributesForMilestoneIds(attributes, names, ids, locale, projectIds);
                break;
            }
            case "tags": {
                names.addAll(targetIds);
                attributes.put(TAGS, names);
                break;
            }
        }
    }

    private void handleAttributesForTestCaseIds(Map<String, List<String>> attributes, List<String> names, List<Long> testCaseIds, Locale locale, List<Long> projectIds) {
        List testCaseFullNames = this.testCaseModificationService.retrieveFullNameByTestCaseLibraryNodeIds(testCaseIds, projectIds);
        names.addAll(testCaseFullNames);
        attributes.put(this.i18nHelper.internationalize("label.testCases", locale), names);
    }

    private void handleAttributesForRequirementIds(Map<String, List<String>> attributes, List<String> names, List<Long> requirementIds, Locale locale, List<Long> projectIds) {
        List requirementFullNames = this.requirementVersionManagerService.retrieveFullNameByRequirementLibraryNodeIds(requirementIds, projectIds);
        names.addAll(requirementFullNames);
        attributes.put(this.i18nHelper.internationalize("label.requirements", locale), names);
    }

    private void handleAttributesForMilestoneIds(Map<String, List<String>> attributes, List<String> names, List<Long> milestoneIds, Locale locale, List<Long> projectIds) {
        List milestoneLabels = this.milestoneManagerService.findMilestoneLabelByIds(milestoneIds, projectIds);
        names.addAll(milestoneLabels);
        attributes.put(this.i18nHelper.internationalize("label.Milestone", locale), names);
    }

    private void handleAttributesForProjectIds(Map<String, List<String>> attributes, List<String> names, List<Long> projectIds, Locale locale) {
        List projectNames = this.customProjectModificationService.findProjectNamesByIds(projectIds);
        names.addAll(projectNames);
        attributes.put(this.i18nHelper.internationalize("label.projects", locale), names);
    }

    private void handleAttributesForCampaignIds(Map<String, List<String>> attributes, List<String> names, List<Long> campaignIds, Locale locale, String entityLabelKey, List<Long> projectIds) {
        List campaignFullNames = this.campaignDisplayService.retrieveFullNameByCampaignLibraryNodeIds(campaignIds, projectIds);
        names.addAll(campaignFullNames);
        if (entityLabelKey.isEmpty()) {
            entityLabelKey = "label.campaigns";
        }
        attributes.put(this.i18nHelper.internationalize(entityLabelKey, locale), names);
    }

    private void handleAttributesForIterationIds(Map<String, List<String>> attributes, List<String> names, List<Long> iterationIds, Locale locale, String entityLabelKey, List<Long> projectIds) {
        List iterationFullNames = this.iterationDisplayService.retrieveFullNameByIterationIds(iterationIds, projectIds);
        names.addAll(iterationFullNames);
        if (entityLabelKey.isEmpty()) {
            entityLabelKey = "label.iterations";
        }
        attributes.put(this.i18nHelper.internationalize(entityLabelKey, locale), names);
    }
}

