/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.tf;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.testautomation.AutomatedSuiteManagerService;
import org.squashtest.tm.service.testautomation.AutomationDeletionCount;

@RestController
@RequestMapping(value={"/backend/cleaning"})
public class AutomatedSuitesCleaningController {
    public static final Logger LOGGER = LoggerFactory.getLogger(AutomatedSuitesCleaningController.class);
    private final AutomatedSuiteManagerService automatedSuiteManagerService;

    public AutomatedSuitesCleaningController(AutomatedSuiteManagerService automatedSuiteManagerService) {
        this.automatedSuiteManagerService = automatedSuiteManagerService;
    }

    @GetMapping(value={"/count"})
    public AutomationDeletionCount getOldAutomatedSuitesAndExecutionsCount() {
        return this.automatedSuiteManagerService.countOldAutomatedSuitesAndExecutions();
    }

    @GetMapping(value={"/{projectId}/count"})
    public AutomationDeletionCount getOldAutomatedSuitesAndExecutionsCountForProject(@PathVariable Long projectId) {
        return this.automatedSuiteManagerService.countOldAutomatedSuitesAndExecutionsForProject(projectId);
    }

    @PostMapping
    public void cleanAutomatedSuitesAndExecutions() {
        this.automatedSuiteManagerService.cleanOldSuites();
    }

    @PostMapping(value={"/{projectId}"})
    public void cleanAutomatedSuitesAndExecutionsForProject(@PathVariable Long projectId) {
        this.automatedSuiteManagerService.cleanOldSuitesForProject(projectId);
    }

    @PostMapping(value={"/{projectId}/prune"}, params={"complete"})
    public void pruneAttachments(@PathVariable Long projectId, @RequestParam(value="complete") boolean complete) {
        this.automatedSuiteManagerService.pruneAttachments(projectId, complete);
    }
}

