/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.tf;

import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.service.internal.dto.executioncomparator.TestExecutionInfo;
import org.squashtest.tm.service.testautomation.AutomatedSuiteManagerService;
import org.squashtest.tm.service.testautomation.model.AutomatedSuiteCreationSpecification;
import org.squashtest.tm.service.testautomation.model.AutomatedSuitePreview;
import org.squashtest.tm.service.testautomation.supervision.AutomatedExecutionViewUtils;
import org.squashtest.tm.service.testautomation.supervision.model.AutomatedSuiteOverview;

@Controller
@RequestMapping(value={"backend/automated-suites"})
public class AutomatedSuiteManagementController {
    @Inject
    private AutomatedSuiteManagerService automatedSuiteService;

    @PostMapping(value={"/preview"})
    @ResponseBody
    public AutomatedSuitePreview generateSuitePreview(@RequestBody AutomatedSuiteCreationSpecification specification) {
        return this.automatedSuiteService.preview(specification);
    }

    @ResponseBody
    @PostMapping(value={"/preview/test-list"}, params={"auto-project-id"})
    public List<String> findTestListPreview(@RequestBody AutomatedSuiteCreationSpecification specification, @RequestParam(value="auto-project-id") Long automatedProjectId) {
        return this.automatedSuiteService.findTestListPreview(specification, automatedProjectId.longValue());
    }

    @ResponseBody
    @PostMapping(value={"/create-and-execute"})
    public AutomatedSuiteOverview createAndExecute(@RequestBody AutomatedSuiteCreationSpecification specification) {
        return this.automatedSuiteService.createAndExecute(specification);
    }

    @ResponseBody
    @GetMapping(value={"/{suiteId}/executions"})
    public AutomatedSuiteOverview updateExecutionInfo(@PathVariable String suiteId) {
        AutomatedSuite suite = this.automatedSuiteService.findById(suiteId);
        return AutomatedExecutionViewUtils.buildAutomatedSuiteOverview((AutomatedSuite)suite);
    }

    @ResponseBody
    @PostMapping(value={"/compare-executions"})
    public List<TestExecutionInfo> compareExecutions(@RequestBody List<String> suiteIds) {
        return this.automatedSuiteService.compareExecutionsBySuites(suiteIds);
    }

    @ResponseBody
    @PostMapping(value={"/deletion"})
    public void deleteAutomatedSuites(@RequestBody List<String> suiteIds) {
        this.automatedSuiteService.deleteAutomatedSuites(suiteIds);
    }

    @ResponseBody
    @PostMapping(value={"/attachment-prune"}, params={"complete"})
    public void pruneAutomatedSuites(@RequestBody List<String> suiteIds, @RequestParam(value="complete") boolean complete) {
        this.automatedSuiteService.pruneAutomatedSuites(suiteIds, complete);
    }
}

