/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testcase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.NodeWorkspace;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.exception.library.RightsUnsuficientsForOperationException;
import org.squashtest.tm.exception.requirement.MilestoneForbidModificationException;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.display.workspace.tree.DatasetDuplicationTreeBrowser;
import org.squashtest.tm.service.display.workspace.tree.MultipleHierarchyTreeBrowser;
import org.squashtest.tm.service.display.workspace.tree.TreeBrowser;
import org.squashtest.tm.service.display.workspace.tree.TreeNodeCollectorService;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.TreeGridResponse;
import org.squashtest.tm.service.internal.display.grid.TreeRequest;
import org.squashtest.tm.service.internal.display.testcase.parameter.TestCaseParameterOperationReport;
import org.squashtest.tm.service.library.LibraryNavigationService;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.service.testcase.fromreq.ReqToTestCaseConfiguration;
import org.squashtest.tm.web.backend.controller.form.model.EntityFormModelValidator;
import org.squashtest.tm.web.backend.controller.form.model.NodeList;
import org.squashtest.tm.web.backend.controller.form.model.NodeListAndWhiteList;
import org.squashtest.tm.web.backend.controller.form.model.TestCaseFolderFormModel;
import org.squashtest.tm.web.backend.controller.form.model.TestCaseFormModel;
import org.squashtest.tm.web.backend.controller.navigation.AbstractLibraryNavigationController;

@RestController
@RequestMapping(path={"backend/test-case-tree"})
public class TestCaseLibraryNavigationController
extends AbstractLibraryNavigationController<TestCaseLibrary, TestCaseFolder, TestCaseLibraryNode> {
    public static final Logger LOGGER = LoggerFactory.getLogger(TestCaseLibraryNavigationController.class);
    private static final String ADD_TEST_CASE = "add-test-case";
    private static final String ADD_TEST_CASE_FOLDER = "add-test-case-folder";
    private final ActiveMilestoneHolder activeMilestoneHolder;
    private final TestCaseLibraryNavigationService testCaseLibraryNavigationService;
    private final TestCaseModificationService testCaseModificationService;
    private final TreeNodeCollectorService treeNodeCollectorService;
    private final DatasetDuplicationTreeBrowser datasetDuplicationTreeBrowser;

    public TestCaseLibraryNavigationController(DatasetDuplicationTreeBrowser datasetDuplicationTreeBrowser, MultipleHierarchyTreeBrowser treeBrowser, ActiveMilestoneHolder activeMilestoneHolder, TestCaseLibraryNavigationService testCaseLibraryNavigationService, TestCaseModificationService testCaseModificationService, TreeNodeCollectorService treeNodeCollectorService, MessageSource messageSource) {
        super((TreeBrowser)treeBrowser, messageSource);
        this.datasetDuplicationTreeBrowser = datasetDuplicationTreeBrowser;
        this.activeMilestoneHolder = activeMilestoneHolder;
        this.testCaseLibraryNavigationService = testCaseLibraryNavigationService;
        this.testCaseModificationService = testCaseModificationService;
        this.treeNodeCollectorService = treeNodeCollectorService;
    }

    @ResponseBody
    @PostMapping(value={"dataset-duplication"})
    public TreeGridResponse getTestCasesEligibleForDatasetDuplication(@RequestBody TreeRequest treeRequest) {
        return this.datasetDuplicationTreeBrowser.getInitialTree(NodeWorkspace.TEST_CASE, NodeReference.fromNodeIds((Collection)treeRequest.getOpenedNodes()), NodeReference.fromNodeIds((Collection)treeRequest.getSelectedNodes()));
    }

    @GetMapping(value={"dataset-duplication/{testCaseId}/{ids}/content"})
    public TreeGridResponse getChildren(@PathVariable Long testCaseId, @PathVariable List<String> ids) {
        Set nodeReference = NodeReference.fromNodeIds(ids);
        return this.datasetDuplicationTreeBrowser.findSubHierarchyFilteredTestCases(nodeReference, new HashSet(nodeReference), testCaseId);
    }

    @ResponseBody
    @PostMapping(value={"dataset-duplication/test-case/{sourceTestCaseId}/paste"})
    public Map<Long, TestCaseParameterOperationReport> pasteDatasets(@RequestBody DatasetDuplicationPatch datasetDuplicationPatch, @PathVariable(value="sourceTestCaseId") Long sourceTestCaseId) {
        return this.testCaseModificationService.copyDatasetInTargetTestCases(datasetDuplicationPatch.getSourceDatasetId(), sourceTestCaseId, datasetDuplicationPatch.getTargetTestCasesIds());
    }

    @ResponseBody
    @PostMapping(value={"new-test-case"}, consumes={"application/json"}, produces={"application/json"})
    public DataRow addNewTestCase(@RequestBody TestCaseFormModel testCaseModel) throws BindException {
        this.validateTestCaseFormModel(testCaseModel);
        TestCase testCase = testCaseModel.getTestCase();
        Map<Long, RawValue> customFieldValues = testCaseModel.getCufs();
        List<Long> milestoneIds = this.findMilestoneIds();
        String serializedParentEntityReference = testCaseModel.getParentEntityReference();
        EntityReference parentEntityReference = EntityReference.fromNodeId((String)serializedParentEntityReference);
        switch (parentEntityReference.getType()) {
            case TEST_CASE_LIBRARY: {
                this.testCaseLibraryNavigationService.addTestCaseToLibrary(parentEntityReference.getId().longValue(), testCase, customFieldValues, null, milestoneIds);
                break;
            }
            case TEST_CASE_FOLDER: {
                this.testCaseLibraryNavigationService.addTestCaseToFolder(parentEntityReference.getId().longValue(), testCase, customFieldValues, null, milestoneIds);
                break;
            }
            default: {
                throw new IllegalArgumentException("This entity type is not handled " + serializedParentEntityReference);
            }
        }
        return this.treeNodeCollectorService.collectNode(NodeType.TEST_CASE, (Identified)testCase);
    }

    @ResponseBody
    @PostMapping(value={"new-folder"}, consumes={"application/json"}, produces={"application/json"})
    public DataRow addNewFolder(@RequestBody TestCaseFolderFormModel folderModel) throws BindException {
        this.validateTestCaseFolderFormModel(folderModel);
        TestCaseFolder testCaseFolder = folderModel.getTestCaseFolder();
        Map<Long, RawValue> customFieldValues = folderModel.getCufs();
        String serializedParentEntityReference = folderModel.getParentEntityReference();
        EntityReference parentEntityReference = EntityReference.fromNodeId((String)serializedParentEntityReference);
        switch (parentEntityReference.getType()) {
            case TEST_CASE_LIBRARY: {
                this.testCaseLibraryNavigationService.addFolderToLibrary(parentEntityReference.getId().longValue(), (Folder)testCaseFolder, customFieldValues);
                break;
            }
            case TEST_CASE_FOLDER: {
                this.testCaseLibraryNavigationService.addFolderToFolder(parentEntityReference.getId().longValue(), (Folder)testCaseFolder, customFieldValues);
                break;
            }
            default: {
                throw new IllegalArgumentException("This entity type is not handled " + serializedParentEntityReference);
            }
        }
        return this.treeNodeCollectorService.collectNode(NodeType.TEST_CASE_FOLDER, (Identified)testCaseFolder);
    }

    @ResponseBody
    @PostMapping(value={"/{destinationId}/content/paste"})
    public void copyNodes(@RequestBody NodeListAndWhiteList nodeListAndWhiteList, @PathVariable(value="destinationId") String destinationId) {
        NodeReference nodeReference = NodeReference.fromNodeId((String)destinationId);
        List<Long> copiedNodeIds = nodeListAndWhiteList.getIds();
        ClipboardPayload clipboardPayload = nodeListAndWhiteList.asClipboardPayload();
        try {
            switch (nodeReference.getNodeType()) {
                case TEST_CASE_FOLDER: {
                    this.testCaseLibraryNavigationService.copyNodesToFolder(nodeReference.getId().longValue(), copiedNodeIds.toArray(new Long[0]), clipboardPayload);
                    break;
                }
                case TEST_CASE_LIBRARY: {
                    this.testCaseLibraryNavigationService.copyNodesToLibrary(nodeReference.getId().longValue(), copiedNodeIds.toArray(new Long[0]), clipboardPayload);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("copy nodes : specified destination type doesn't exists : " + nodeReference.getNodeType());
                }
            }
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
    }

    @ResponseBody
    @PostMapping(value={"/{destinationId}/content/paste-from-requirement/{tcKind}"})
    public void copyFromRequirementToTestCases(@PathVariable(value="destinationId") String destinationId, @PathVariable(value="tcKind") String tcKind, @RequestBody NodeList nodeList, Locale locale) {
        NodeReference nodeReference = NodeReference.fromNodeId((String)destinationId);
        List<Long> copiedNodeIdsList = nodeList.getIds();
        Long[] copiedNodeIds = copiedNodeIdsList.toArray(new Long[0]);
        ReqToTestCaseConfiguration configuration = new ReqToTestCaseConfiguration(tcKind);
        try {
            switch (nodeReference.getNodeType()) {
                case TEST_CASE_FOLDER: {
                    this.testCaseLibraryNavigationService.copyReqToTestCasesToFolder(nodeReference.getId().longValue(), copiedNodeIds, configuration);
                    break;
                }
                case TEST_CASE_LIBRARY: {
                    this.testCaseLibraryNavigationService.copyReqToTestCasesToLibrary(nodeReference.getId().longValue(), copiedNodeIds, configuration);
                    break;
                }
                case TEST_CASE: {
                    this.testCaseLibraryNavigationService.copyReqToTestCasesToTestCases(nodeReference.getId().longValue(), copiedNodeIds, configuration);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("copy nodes : specified destination type doesn't exists : " + nodeReference.getNodeType());
                }
            }
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
    }

    @ResponseBody
    @PostMapping(value={"/{destinationRef}/content/move"})
    public void moveNodes(@RequestBody NodeList nodeList, @PathVariable(value="destinationRef") String destinationRef) {
        NodeReference nodeReference = NodeReference.fromNodeId((String)destinationRef);
        Long destinationId = nodeReference.getId();
        NodeType destinationType = nodeReference.getNodeType();
        Long[] movedNodeIds = nodeList.getIds().toArray(new Long[0]);
        ClipboardPayload clipboardPayload = ClipboardPayload.withWhiteListIgnored(nodeList.getIds());
        try {
            switch (destinationType) {
                case TEST_CASE_FOLDER: {
                    this.testCaseLibraryNavigationService.moveNodesToFolder(destinationId.longValue(), movedNodeIds, clipboardPayload);
                    break;
                }
                case TEST_CASE_LIBRARY: {
                    this.testCaseLibraryNavigationService.moveNodesToLibrary(destinationId.longValue(), movedNodeIds, clipboardPayload);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("move nodes : specified destination type doesn't exists : " + destinationType);
                }
            }
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
    }

    @ResponseBody
    @PostMapping(value={"/{destinationRef}/content/move/{position}"})
    public void moveNodesAtPosition(@RequestBody NodeList nodeList, @PathVariable(value="destinationRef") String destinationRef, @PathVariable(value="position") int position) {
        NodeReference nodeReference = NodeReference.fromNodeId((String)destinationRef);
        Long destinationId = nodeReference.getId();
        NodeType destinationType = nodeReference.getNodeType();
        Long[] movedNodeIds = nodeList.getIds().toArray(new Long[0]);
        ClipboardPayload clipboardPayload = ClipboardPayload.withWhiteListIgnored(nodeList.getIds());
        try {
            switch (destinationType) {
                case TEST_CASE_FOLDER: {
                    this.testCaseLibraryNavigationService.moveNodesToFolder(destinationId.longValue(), movedNodeIds, position, clipboardPayload);
                    break;
                }
                case TEST_CASE_LIBRARY: {
                    this.testCaseLibraryNavigationService.moveNodesToLibrary(destinationId.longValue(), movedNodeIds, position, clipboardPayload);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("move nodes : specified destination type doesn't exists : " + destinationType);
                }
            }
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
    }

    @ResponseBody
    @PostMapping(value={"{testCaseId}/new-version"}, consumes={"application/json"}, produces={"application/json"})
    public NewTestCaseVersion createNewVersion(@PathVariable Long testCaseId, @RequestBody TestCaseFormModel testCaseFormModel) throws BindException, MilestoneForbidModificationException {
        this.validateTestCaseFormModel(testCaseFormModel);
        TestCase testCase = testCaseFormModel.getTestCase();
        TestCase newTestCase = this.testCaseModificationService.addNewTestCaseVersion(testCaseId.longValue(), testCase);
        return new NewTestCaseVersion(newTestCase.getId());
    }

    @PostMapping(value={"/transmit-eligible-tcs"})
    @ResponseBody
    public Map<String, Object> transmitEligibleNodes(@RequestBody Map<String, List<Long>> selectedNodes) {
        return this.testCaseModificationService.transmitEligibleNodes(selectedNodes);
    }

    private void validateTestCaseFormModel(TestCaseFormModel testCaseModel) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)testCaseModel, ADD_TEST_CASE);
        EntityFormModelValidator entityFormModelValidator = new EntityFormModelValidator();
        entityFormModelValidator.validate(testCaseModel, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
    }

    private void validateTestCaseFolderFormModel(TestCaseFolderFormModel folderModel) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)folderModel, ADD_TEST_CASE_FOLDER);
        EntityFormModelValidator entityFormModelValidator = new EntityFormModelValidator();
        entityFormModelValidator.validate(folderModel, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
    }

    private List<Long> findMilestoneIds() {
        ArrayList<Long> milestoneIds = new ArrayList<Long>();
        Optional activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        activeMilestone.ifPresent(milestone -> {
            boolean bl = milestoneIds.add(milestone.getId());
        });
        return milestoneIds;
    }

    @Override
    protected LibraryNavigationService<TestCaseLibrary, TestCaseFolder, TestCaseLibraryNode> getLibraryNavigationService() {
        return this.testCaseLibraryNavigationService;
    }

    @Override
    protected NodeWorkspace getWorkspace() {
        return NodeWorkspace.TEST_CASE;
    }

    public static class DatasetDuplicationPatch {
        List<Long> targetTestCasesIds;
        Long sourceDatasetId;

        public List<Long> getTargetTestCasesIds() {
            return this.targetTestCasesIds;
        }

        public Long getSourceDatasetId() {
            return this.sourceDatasetId;
        }
    }

    static class NewTestCaseVersion {
        private final Long newVersionId;

        NewTestCaseVersion(Long newVersionId) {
            this.newVersionId = newVersionId;
        }

        public Long getNewVersionId() {
            return this.newVersionId;
        }
    }
}

