/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.test.automation.server.environments.projectlevel;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.service.display.test.automation.server.TestAutomationServerDisplayService;
import org.squashtest.tm.service.internal.display.dto.automatedexecutionenvironments.EnvironmentSelectionPanelDto;
import org.squashtest.tm.service.project.CustomProjectModificationService;
import org.squashtest.tm.service.project.GenericProjectFinder;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.testautomation.environment.AutomatedExecutionEnvironmentService;
import org.squashtest.tm.web.backend.controller.form.model.StringList;
import org.squashtest.tm.web.backend.controller.test.automation.server.environments.AbstractTAEnvironmentsController;

@Controller
@RequestMapping(value={"/backend/generic-projects/"})
public class ProjectLevelTAEnvironmentsController
extends AbstractTAEnvironmentsController {
    private final CustomProjectModificationService customProjectModificationService;

    public ProjectLevelTAEnvironmentsController(AutomatedExecutionEnvironmentService automatedExecutionEnvironmentService, CustomProjectModificationService customProjectModificationService, StoredCredentialsManager storedCredentialsManager, GenericProjectFinder genericProjectFinder, TestAutomationServerDisplayService testAutomationServerDisplayService) {
        super(automatedExecutionEnvironmentService, storedCredentialsManager, genericProjectFinder, testAutomationServerDisplayService);
        this.customProjectModificationService = customProjectModificationService;
    }

    @ResponseBody
    @GetMapping(value={"{projectId}/available-tags"})
    public StringList getAllAvailableProjectEnvironmentTags(@PathVariable Long projectId) {
        return this.getAvailableProjectEnvironmentTags(projectId);
    }

    @ResponseBody
    @GetMapping(value={"{projectId}/automated-execution-environments/all"})
    public EnvironmentSelectionPanelDto getProjectEnvironments(@PathVariable Long projectId) {
        return this.getProjectEnvironmentsPanel(projectId);
    }

    @ResponseBody
    @PostMapping(value={"{projectId}/environment-tags"})
    public void updateProjectEnvironmentTags(@PathVariable Long projectId, @RequestBody StringList tagList) {
        this.customProjectModificationService.overrideEnvironmentTags(projectId.longValue(), tagList.getList());
    }

    @ResponseBody
    @DeleteMapping(value={"{projectId}/environment-tags"})
    public void clearProjectTagOverrides(@PathVariable Long projectId) {
        this.customProjectModificationService.clearEnvironmentTagOverrides(projectId.longValue());
    }

    @ResponseBody
    @PostMapping(value={"{projectId}/automated-execution-environments/tokens/{serverId}"})
    public void changeTAServerTokenOverride(@PathVariable Long projectId, @PathVariable Long serverId, @RequestBody TokenOverrideRequestBody body) {
        this.customProjectModificationService.setTestAutomationServerTokenOverride(projectId.longValue(), serverId.longValue(), body.token);
    }

    @ResponseBody
    @DeleteMapping(value={"{projectId}/automated-execution-environments/tokens/{serverId}"})
    public void clearTAServerTokenOverride(@PathVariable Long projectId, @PathVariable Long serverId) {
        this.customProjectModificationService.clearTestAutomationServerTokenOverride(projectId.longValue(), serverId.longValue());
    }

    public static class TokenOverrideRequestBody {
        private String token;

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }
    }
}

