/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.system;

import java.io.File;
import java.util.Arrays;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.core.io.FileSystemResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.system.SystemAdministrationService;

@RestController
@RequestMapping(value={"/backend/system"})
public class SystemAdministrationController {
    private static final String APPLICATION_SLASH_OCTET_STREAM = "application/octet-stream";
    private static final String ATTACHMENT_FILENAME = "attachment; filename=";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String FILENAME = "filename";
    @Value(value="${logging.dir}")
    private String loggingPath;
    private final Environment environment;
    private final SystemAdministrationService systemAdministrationService;

    SystemAdministrationController(SystemAdministrationService systemAdministrationService, Environment environment) {
        this.systemAdministrationService = systemAdministrationService;
        this.environment = environment;
    }

    @PostMapping(value={"/settings/white-list"})
    void changeWhiteList(@RequestBody SystemSettingsPatch patch) {
        this.systemAdministrationService.changeWhiteList(patch.whiteList());
    }

    @PostMapping(value={"/settings/upload-size-limit"})
    void changeUploadSizeLimit(@RequestBody SystemSettingsPatch patch) {
        this.systemAdministrationService.changeUploadSizeLimit(patch.uploadSizeLimit());
    }

    @PostMapping(value={"/settings/import-size-limit"})
    void changeImportSizeLimit(@RequestBody SystemSettingsPatch patch) {
        this.systemAdministrationService.changeImportSizeLimit(patch.importSizeLimit());
    }

    @PostMapping(value={"/settings/callback-url"})
    void changeCallbackUrl(@RequestBody SystemSettingsPatch patch) {
        this.systemAdministrationService.changeCallbackUrl(patch.callbackUrl());
    }

    @PostMapping(value={"/messages/welcome-message"})
    void changeWelcomeMessage(@RequestBody SystemMessagesPatch patch) {
        this.systemAdministrationService.changeWelcomeMessage(patch.welcomeMessage());
    }

    @PostMapping(value={"/messages/login-message"})
    void changeLoginMessage(@RequestBody SystemMessagesPatch patch) {
        this.systemAdministrationService.changeLoginMessage(patch.loginMessage());
    }

    @PostMapping(value={"/messages/banner-message"})
    void changeBannerMessage(@RequestBody SystemMessagesPatch patch) {
        this.systemAdministrationService.changeBannerMessage(patch.bannerMessage());
    }

    @GetMapping(value={"logs/latest"})
    FileSystemResource downloadCurrentLogfile(HttpServletResponse response) {
        File logfile = this.getCurrentLogFile();
        response.setContentType(APPLICATION_SLASH_OCTET_STREAM);
        response.setHeader(CONTENT_DISPOSITION, "attachment; filename=squash-tm.log");
        return new FileSystemResource(logfile);
    }

    @GetMapping(value={"logs"}, params={"filename"})
    FileSystemResource downloadLogfile(@RequestParam(value="filename") String filename, HttpServletResponse response) {
        File logfile = this.getLogFile(filename);
        response.setContentType(APPLICATION_SLASH_OCTET_STREAM);
        response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + logfile.getName());
        return new FileSystemResource(logfile);
    }

    private File getCurrentLogFile() {
        if (Arrays.asList(this.environment.getActiveProfiles()).contains("dev")) {
            return new File(String.valueOf(this.loggingPath) + "/spring.log");
        }
        return new File(String.valueOf(this.loggingPath) + "/squash-tm.log");
    }

    private File getLogFile(String fileName) {
        if (Arrays.asList(this.environment.getActiveProfiles()).contains("dev")) {
            throw new RuntimeException("You should not call getLogFile in a dev build.");
        }
        return new File(String.valueOf(this.loggingPath) + "/" + fileName);
    }

    record SystemMessagesPatch(String welcomeMessage, String loginMessage, String bannerMessage) {
    }

    record SystemSettingsPatch(String whiteList, String uploadSizeLimit, String importSizeLimit, String callbackUrl) {
    }
}

