/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.requirement;

import java.util.List;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.service.display.requirements.RequirementDisplayService;
import org.squashtest.tm.service.internal.display.dto.MilestoneDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;

@Controller
@RequestMapping(value={"backend/requirement-version/{requirementVersionId}"})
public class RequirementVersionModificationController {
    private final RequirementVersionManagerService requirementVersionManager;
    private final RequirementDisplayService requirementDisplayService;

    public RequirementVersionModificationController(RequirementVersionManagerService requirementVersionManager, RequirementDisplayService requirementDisplayService) {
        this.requirementVersionManager = requirementVersionManager;
        this.requirementDisplayService = requirementDisplayService;
    }

    @ResponseBody
    @PostMapping(value={"/history"})
    public GridResponse getHistory(@PathVariable Long requirementVersionId, @RequestBody GridRequest requestParam) {
        return this.requirementDisplayService.findCurrentVersionModificationHistoryByRequirementVersionId(requirementVersionId, requestParam);
    }

    @ResponseBody
    @PostMapping(value={"/name"})
    public void rename(@PathVariable Long requirementVersionId, @RequestBody RequirementVersionPatch patch) {
        this.requirementVersionManager.rename(requirementVersionId.longValue(), patch.getName());
    }

    @ResponseBody
    @PostMapping(value={"/reference"})
    public void changeReference(@PathVariable Long requirementVersionId, @RequestBody RequirementVersionPatch patch) {
        this.requirementVersionManager.changeReference(requirementVersionId.longValue(), patch.getReference());
    }

    @ResponseBody
    @PostMapping(value={"/description"})
    public void changeDescription(@PathVariable Long requirementVersionId, @RequestBody RequirementVersionPatch patch) {
        this.requirementVersionManager.changeDescription(requirementVersionId.longValue(), patch.getDescription());
    }

    @ResponseBody
    @PostMapping(value={"/category"})
    public void changeCategory(@PathVariable Long requirementVersionId, @RequestBody RequirementVersionPatch patch) {
        this.requirementVersionManager.changeCategory(requirementVersionId.longValue(), patch.getCategory());
    }

    @ResponseBody
    @PostMapping(value={"/criticality"})
    public void changeCriticality(@PathVariable Long requirementVersionId, @RequestBody RequirementVersionPatch patch) {
        this.requirementVersionManager.changeCriticality(requirementVersionId.longValue(), RequirementCriticality.valueOf((String)patch.getCriticality()));
    }

    @ResponseBody
    @PostMapping(value={"/status"})
    public void changeStatus(@PathVariable Long requirementVersionId, @RequestBody RequirementVersionPatch patch) {
        this.requirementVersionManager.changeStatus(requirementVersionId.longValue(), RequirementStatus.valueOf((String)patch.getStatus()));
    }

    @RequestMapping(value={"/milestones/{milestoneIds}"}, method={RequestMethod.POST})
    @ResponseBody
    public List<MilestoneDto> bindMilestones(@PathVariable long requirementVersionId, @PathVariable(value="milestoneIds") List<Long> milestoneIds) {
        this.requirementVersionManager.bindMilestones(requirementVersionId, milestoneIds);
        return this.requirementDisplayService.findBindableMilestones(Long.valueOf(requirementVersionId));
    }

    @ResponseBody
    @RequestMapping(value={"/milestones/{milestoneIds}"}, method={RequestMethod.DELETE})
    public List<MilestoneDto> unbindMilestones(@PathVariable long requirementVersionId, @PathVariable List<Long> milestoneIds) {
        this.requirementVersionManager.unbindMilestones(requirementVersionId, milestoneIds);
        return this.requirementDisplayService.findBindableMilestones(Long.valueOf(requirementVersionId));
    }

    static class RequirementVersionPatch {
        private String name;
        private String reference;
        private String description;
        private Long category;
        private String status;
        private String criticality;

        RequirementVersionPatch() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getReference() {
            return this.reference;
        }

        public void setReference(String reference) {
            this.reference = reference;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Long getCategory() {
            return this.category;
        }

        public void setCategory(Long category) {
            this.category = category;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getCriticality() {
            return this.criticality;
        }

        public void setCriticality(String criticality) {
            this.criticality = criticality;
        }
    }
}

